/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.util.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContentType<T> {
    private final List<DisplayUnit<T>> m_displayUnits = new ArrayList<DisplayUnit<T>>();
    private final String m_identifier;
    private final String m_localizedName;

    ContentType(String identifier) {
        this(identifier, Messages.getString("ContentType_" + identifier));
    }

    ContentType(String identifier, String localizedName) {
        this.m_identifier = identifier;
        this.m_localizedName = localizedName;
    }

    public Map<String, String> createDisplayUnitMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (DisplayUnit<T> unit : this.m_displayUnits) {
            map.put(unit.getIdentifier(), unit.getName());
        }
        return map;
    }

    void addDisplayUnit(DisplayUnit<T> displayUnit) {
        this.m_displayUnits.add(displayUnit);
    }

    public List<DisplayUnit<T>> getDisplayUnits() {
        return Collections.unmodifiableList(this.m_displayUnits);
    }

    public DisplayUnit<T> getDefaultDisplayUnit() {
        return this.m_displayUnits.get(0);
    }

    public String getName() {
        return this.m_localizedName;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public DisplayUnit<T> getDisplayUnit(String displayUnitIdentifier) {
        for (DisplayUnit<T> du : this.m_displayUnits) {
            if (!displayUnitIdentifier.equals(du.getIdentifier())) continue;
            return du;
        }
        return this.m_displayUnits.get(0);
    }
}

