/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderLayoutData;
import java.util.Arrays;

public class RenderLayout {
    private final RenderLayoutData[] m_layoutData;
    private final RenderLayoutData[] m_sortData;
    private int m_index = 0;

    public RenderLayout(int size) {
        this.m_layoutData = new RenderLayoutData[size];
        this.m_sortData = new RenderLayoutData[size];
        int n = 0;
        while (n < size) {
            this.m_layoutData[n] = new RenderLayoutData();
            ++n;
        }
    }

    public void clear() {
        this.m_index = 0;
    }

    public void addLayoutData(RenderLayoutData prototype) {
        if (this.m_index < this.m_layoutData.length) {
            this.m_layoutData[this.m_index].maxSize = prototype.maxSize;
            this.m_layoutData[this.m_index].minSize = prototype.minSize;
            this.m_layoutData[this.m_index].weight = prototype.weight;
            this.m_sortData[this.m_index] = this.m_layoutData[this.m_index];
            ++this.m_index;
        }
    }

    public RenderLayoutData getData(int index) {
        return this.m_layoutData[index];
    }

    public void computeSizes(int height) {
        if (this.m_index == 0) {
            return;
        }
        Arrays.sort(this.m_sortData, 0, this.m_index - 1);
        int layer = 0;
        boolean maxedOut = false;
        while (height > 0 && !maxedOut) {
            maxedOut = true;
            int n = 0;
            while (n < this.m_index) {
                if (layer == 0) {
                    this.m_sortData[n].size = this.m_sortData[n].minSize;
                    height -= this.m_sortData[n].minSize;
                    maxedOut = false;
                } else if (this.m_sortData[n].maxSize > this.m_sortData[n].size) {
                    maxedOut = false;
                    if (layer % this.m_sortData[n].weight == 0) {
                        ++this.m_sortData[n].size;
                        if (--height == 0) {
                            return;
                        }
                    }
                }
                ++n;
            }
            ++layer;
        }
    }

    public int getSize() {
        return this.m_index;
    }
}

