/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.common.DefaultTimestampedData;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.multichart.Chart;
import com.jrockit.mc.flightrecorder.ui.components.multichart.TimestampDataSeries;
import com.jrockit.mc.flightrecorder.ui.components.multichart.TimestampSeriesProvider;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

final class ChartContentProvider
implements IStructuredContentProvider {
    private final HashMap<Object, Chart> m_keySeriesMap = new HashMap();
    private FLRChartDescriptor m_chartDescriptor;
    private final String m_attribute;

    public ChartContentProvider(FLRChartDescriptor cd) {
        this.m_chartDescriptor = cd;
        this.m_attribute = cd.getGroupBy().getAttribute();
    }

    public void addEvent(IEvent e) {
        Object key = e.getValue(this.m_attribute);
        if (key != null) {
            Chart chart = this.m_keySeriesMap.get(key);
            if (chart == null) {
                chart = this.createChart(key, this.m_chartDescriptor);
                this.m_keySeriesMap.put(key, chart);
            }
            chart.addEvent(e);
            TimestampDataSeries[] timestampDataSeriesArray = chart.getDataProvider().getDataSeries();
            int n = timestampDataSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimestampDataSeries ds = timestampDataSeriesArray[n2];
                ds.add((ITimestampedData)new DefaultTimestampedData(Long.valueOf(e.getEndTimestamp()), (Number)e.getDuration()));
                ++n2;
            }
        }
    }

    private Chart createChart(Object key, FLRChartDescriptor chartDescriptor) {
        return new Chart(key, this.createDataProvider(chartDescriptor));
    }

    public TimestampSeriesProvider createDataProvider(FLRChartDescriptor chartDescriptor) {
        ArrayList<TimestampDataSeries> series = new ArrayList<TimestampDataSeries>();
        int i = 0;
        while (i < chartDescriptor.getDataSeriesDescriptors().size()) {
            series.add(new TimestampDataSeries());
            ++i;
        }
        return new TimestampSeriesProvider(series.toArray(new TimestampDataSeries[series.size()]));
    }

    public Chart getChart(Object key) {
        return this.m_keySeriesMap.get(key);
    }

    public void dispose() {
        this.m_keySeriesMap.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.m_chartDescriptor = null;
        if (newInput instanceof FLRChartDescriptor) {
            this.m_chartDescriptor = (FLRChartDescriptor)((Object)newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.m_keySeriesMap.keySet().toArray();
    }
}

