/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ContentProviderBuilder
extends ViewModelBuilder<ChartContentProvider> {
    private final FLRChartDescriptor m_descriptor;

    public ContentProviderBuilder(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, String name) {
        super(serviceLocator, name);
        this.m_descriptor = (FLRChartDescriptor)((Object)PersistenceToolkit.createCopy((Object)((Object)chartDescriptor)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FLRChartDescriptor createLocalChartDescriptor(FLRChartDescriptor cd) {
        FLRChartDescriptor fLRChartDescriptor = cd;
        synchronized (fLRChartDescriptor) {
            return (FLRChartDescriptor)((Object)PersistenceToolkit.createCopy((Object)((Object)cd)));
        }
    }

    @Override
    protected ChartContentProvider buildModel(IView view, IProgressMonitor monitor) {
        FLRChartDescriptor cd = this.createLocalChartDescriptor(this.m_descriptor);
        EventTypeDescriptorRepository er = this.m_descriptor.getGroupBy().getEventTypeRepository();
        EventTypeAcceptor acc = new EventTypeAcceptor(this.getServiceLocator(), er);
        view.setEventTypes(acc.getAcceptedSet());
        view.setOrder(EventOrder.ASCENDING);
        ChartContentProvider contentProvider = new ChartContentProvider(cd);
        for (IEvent e : view) {
            contentProvider.addEvent(e);
        }
        return contentProvider;
    }
}

