/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.fields;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRMethod;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.internal.model.FLRType;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;

public final class AlmostThreadRootFrameField
extends Field {
    private final IField m_field;
    public static final IMCFrame UNKNOWN = AlmostThreadRootFrameField.createUnknownFrame();

    public AlmostThreadRootFrameField(IEventType type, String attributIdentifier, IField field) {
        super(type, "(" + attributIdentifier + ".almostThreadRootframe)");
        this.m_field = field;
        this.setName("Stacktrace (Almost Thread Root Frame)");
        this.setDescription("The frame next to the top frame.");
        this.setFieldType(FieldType.OBJECT);
        this.setContentType(UnitLookup.METHOD.getIdentifier());
        this.setVisible(false);
        this.setSynthetic(true);
    }

    private static IMCFrame createUnknownFrame() {
        FLRMethod m = new FLRMethod();
        FLRType type = new FLRType("~ UNCLASSIFIABLE ~");
        m.setType((IMCType)type);
        m.setPackageName("");
        m.setClassName("~ UNCLASSIFIABLE ~");
        m.setMethodName("");
        m.setFormalDescriptor("()V;");
        return new FLRFrame((IMCMethod)m, null, null, IMCFrame.Type.UNKNOWN);
    }

    @Override
    public Object getValue(IEvent event) {
        FLRFrame f;
        Object o = this.m_field.getValue(event);
        if (o instanceof FLRStackTrace && (f = ((FLRStackTrace)o).getAlmostThreadRootFrame()) != null) {
            return f;
        }
        return UNKNOWN;
    }
}

