/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import java.util.Iterator;

public final class FilteredIterator
implements Iterator<IEvent> {
    private final IEventFilter m_filter;
    private final Iterator<IEvent> m_iterator;
    private IEvent m_event;

    public FilteredIterator(Iterator<IEvent> iterator, IEventFilter filter) {
        this.m_iterator = iterator;
        this.m_filter = filter;
        this.skipToNext();
    }

    private void skipToNext() {
        while (this.m_iterator.hasNext()) {
            IEvent e = this.m_iterator.next();
            if (!this.m_filter.accept(e)) continue;
            this.m_event = e;
            return;
        }
        this.m_event = null;
    }

    @Override
    public boolean hasNext() {
        return this.m_event != null;
    }

    @Override
    public IEvent next() {
        IEvent event = this.m_event;
        this.skipToNext();
        return event;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("");
    }
}

