/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public abstract class AbstractModMetadata
implements ModMetadata {
    @Override
    public boolean containsCustomElement(String key) {
        return this.containsCustomValue(key);
    }

    @Override
    public JsonElement getCustomElement(String key) {
        CustomValue value = this.getCustomValue(key);
        return value != null ? AbstractModMetadata.convert(value) : null;
    }

    @Override
    public boolean containsCustomValue(String key) {
        return this.getCustomValues().containsKey(key);
    }

    @Override
    public CustomValue getCustomValue(String key) {
        return this.getCustomValues().get(key);
    }

    @Deprecated
    private static JsonElement convert(CustomValue value) {
        switch (value.getType()) {
            case ARRAY: {
                JsonArray ret = new JsonArray();
                for (CustomValue v : value.getAsArray()) {
                    ret.add(AbstractModMetadata.convert(v));
                }
                return ret;
            }
            case BOOLEAN: {
                return new JsonPrimitive(Boolean.valueOf(value.getAsBoolean()));
            }
            case NULL: {
                return JsonNull.INSTANCE;
            }
            case NUMBER: {
                return new JsonPrimitive(value.getAsNumber());
            }
            case OBJECT: {
                JsonObject ret = new JsonObject();
                for (Map.Entry entry : value.getAsObject()) {
                    ret.add((String)entry.getKey(), AbstractModMetadata.convert((CustomValue)entry.getValue()));
                }
                return ret;
            }
            case STRING: {
                return new JsonPrimitive(value.getAsString());
            }
        }
        throw new IllegalStateException();
    }
}

