/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.core;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.IteratorInt;

public final class VecInt
implements IVecInt {
    private static final long serialVersionUID = 1L;
    public static final IVecInt EMPTY = new IVecInt(){
        private static final long serialVersionUID = 1L;

        public int size() {
            return 0;
        }

        public void shrink(int nofelems) {
        }

        public void shrinkTo(int newsize) {
        }

        public IVecInt pop() {
            throw new UnsupportedOperationException();
        }

        public void growTo(int newsize, int pad) {
        }

        public void ensure(int nsize) {
        }

        public IVecInt push(int elem) {
            throw new UnsupportedOperationException();
        }

        public void unsafePush(int elem) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
        }

        public int last() {
            throw new UnsupportedOperationException();
        }

        public int get(int i) {
            throw new UnsupportedOperationException();
        }

        public void set(int i, int o) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(int e) {
            return false;
        }

        public void copyTo(IVecInt copy) {
        }

        public void copyTo(int[] is) {
        }

        public void moveTo(IVecInt dest) {
        }

        public void moveTo2(IVecInt dest) {
        }

        public void moveTo(int[] dest) {
        }

        public void insertFirst(int elem) {
            throw new UnsupportedOperationException();
        }

        public void remove(int elem) {
            throw new UnsupportedOperationException();
        }

        public int delete(int i) {
            throw new UnsupportedOperationException();
        }

        public void sort() {
        }

        public void sortUnique() {
        }

        public int unsafeGet(int eleem) {
            throw new UnsupportedOperationException();
        }

        public int containsAt(int e) {
            throw new UnsupportedOperationException();
        }

        public int containsAt(int e, int from) {
            throw new UnsupportedOperationException();
        }

        public void moveTo(int dest, int source) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return true;
        }

        public IteratorInt iterator() {
            return new IteratorInt(){

                public boolean hasNext() {
                    return false;
                }

                public int next() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int[] toArray() {
            throw new UnsupportedOperationException();
        }

        public int indexOf(int e) {
            return -1;
        }

        public String toString() {
            return "[]";
        }

        public void moveTo(int sourceStartingIndex, int[] dest) {
            throw new UnsupportedOperationException();
        }

        public IVecInt[] subset(int cardinal) {
            return new IVecInt[0];
        }

        public boolean equals(Object o) {
            if (o instanceof IVecInt) {
                return ((IVecInt)o).isEmpty();
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    };
    private int nbelem;
    private int[] myarray;

    public VecInt() {
        this(5);
    }

    public VecInt(int size) {
        this.myarray = new int[size];
    }

    public VecInt(int[] lits) {
        this.myarray = lits;
        this.nbelem = lits.length;
    }

    public VecInt(int size, int pad) {
        this.myarray = new int[size];
        for (int i = 0; i < size; ++i) {
            this.myarray[i] = pad;
        }
        this.nbelem = size;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int nofelems) {
        this.nbelem -= nofelems;
    }

    public void shrinkTo(int newsize) {
        this.nbelem = newsize;
    }

    public IVecInt pop() {
        --this.nbelem;
        return this;
    }

    public void growTo(int newsize, int pad) {
        this.ensure(newsize);
        while (--newsize >= 0) {
            this.myarray[this.nbelem++] = pad;
        }
    }

    public void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            int[] narray = new int[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    public IVecInt push(int elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    public void unsafePush(int elem) {
        this.myarray[this.nbelem++] = elem;
    }

    public void clear() {
        this.nbelem = 0;
    }

    public int last() {
        return this.myarray[this.nbelem - 1];
    }

    public int get(int i) {
        return this.myarray[i];
    }

    public int unsafeGet(int i) {
        return this.myarray[i];
    }

    public void set(int i, int o) {
        assert (i >= 0 && i < this.nbelem);
        this.myarray[i] = o;
    }

    public boolean contains(int e) {
        int[] workArray = this.myarray;
        for (int i = 0; i < this.nbelem; ++i) {
            if (workArray[i] != e) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int e) {
        int[] workArray = this.myarray;
        for (int i = 0; i < this.nbelem; ++i) {
            if (workArray[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int containsAt(int e) {
        return this.containsAt(e, -1);
    }

    public int containsAt(int e, int from) {
        int[] workArray = this.myarray;
        for (int i = from + 1; i < this.nbelem; ++i) {
            if (workArray[i] != e) continue;
            return i;
        }
        return -1;
    }

    public void copyTo(IVecInt copy) {
        VecInt ncopy = (VecInt)copy;
        int nsize = this.nbelem + ncopy.nbelem;
        ncopy.ensure(nsize);
        System.arraycopy(this.myarray, 0, ncopy.myarray, ncopy.nbelem, this.nbelem);
        ncopy.nbelem = nsize;
    }

    public void copyTo(int[] is) {
        System.arraycopy(this.myarray, 0, is, 0, this.nbelem);
    }

    public void moveTo(IVecInt dest) {
        this.copyTo(dest);
        this.nbelem = 0;
    }

    public void moveTo2(IVecInt dest) {
        VecInt ndest = (VecInt)dest;
        int[] tmp = ndest.myarray;
        ndest.myarray = this.myarray;
        ndest.nbelem = this.nbelem;
        this.myarray = tmp;
        this.nbelem = 0;
    }

    public void moveTo(int dest, int source) {
        this.myarray[dest] = this.myarray[source];
    }

    public void moveTo(int[] dest) {
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
        this.nbelem = 0;
    }

    public void moveTo(int sourceStartingIndex, int[] dest) {
        System.arraycopy(this.myarray, sourceStartingIndex, dest, 0, this.nbelem - sourceStartingIndex);
        this.nbelem = 0;
    }

    public void insertFirst(int elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    public void remove(int elem) {
        int j = 0;
        while (this.myarray[j] != elem) {
            assert (j < this.size());
            ++j;
        }
        System.arraycopy(this.myarray, j + 1, this.myarray, j, this.size() - j - 1);
        this.pop();
    }

    public int delete(int i) {
        int ith = this.myarray[i];
        this.myarray[i] = this.myarray[--this.nbelem];
        return ith;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stb.append(this.myarray[i]);
            stb.append(",");
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int besti = i;
            for (int j = i + 1; j < to; ++j) {
                if (this.myarray[j] >= this.myarray[besti]) continue;
                besti = j;
            }
            int tmp = this.myarray[i];
            this.myarray[i] = this.myarray[besti];
            this.myarray[besti] = tmp;
        }
    }

    void sort(int from, int to) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to);
        } else {
            int[] locarray = this.myarray;
            int pivot = locarray[width / 2 + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (locarray[++i] < pivot) {
                    continue;
                }
                while (pivot < locarray[--j]) {
                }
                if (i >= j) break;
                int tmp = locarray[i];
                locarray[i] = locarray[j];
                locarray[j] = tmp;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    public void sort() {
        this.sort(0, this.nbelem);
    }

    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int i = 1;
        int[] locarray = this.myarray;
        int last = locarray[0];
        for (int j = 1; j < this.nbelem; ++j) {
            if (last >= locarray[j]) continue;
            last = locarray[i] = locarray[j];
            ++i;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVecInt) {
            IVecInt v = (IVecInt)obj;
            if (v.size() != this.nbelem) {
                return false;
            }
            for (int i = 0; i < this.nbelem; ++i) {
                if (v.get(i) == this.myarray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long sum = 0L;
        for (int i = 0; i < this.nbelem; ++i) {
            sum += (long)this.myarray[i];
        }
        return (int)sum / this.nbelem;
    }

    public void pushAll(IVecInt vec) {
        VecInt nvec = (VecInt)vec;
        int nsize = this.nbelem + nvec.nbelem;
        this.ensure(nsize);
        System.arraycopy(nvec.myarray, 0, this.myarray, this.nbelem, nvec.nbelem);
        this.nbelem = nsize;
    }

    public boolean isSubsetOf(VecInt vec) {
        int j = 0;
        for (int i = 0; i < this.nbelem && j < vec.nbelem; ++i) {
            while (j < vec.nbelem && vec.myarray[j] < this.myarray[i]) {
                ++j;
            }
            if (j != vec.nbelem && this.myarray[i] == vec.myarray[j]) continue;
            return false;
        }
        return true;
    }

    public IteratorInt iterator() {
        return new IteratorInt(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < VecInt.this.nbelem;
            }

            public int next() {
                if (this.i == VecInt.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return VecInt.this.myarray[this.i++];
            }
        };
    }

    public boolean isEmpty() {
        return this.nbelem == 0;
    }

    public int[] toArray() {
        return this.myarray;
    }

    public IVecInt[] subset(int cardinal) {
        ArrayList<IVecInt> liste = new ArrayList<IVecInt>();
        if (cardinal == 1) {
            IVecInt[] result = new VecInt[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                result[i] = new VecInt(new int[]{this.get(i)});
            }
            return result;
        }
        if (this.size() == 0) {
            IVecInt[] result = new VecInt[]{};
            return result;
        }
        VecInt subVec = new VecInt();
        this.copyTo(subVec);
        subVec.remove(this.get(0));
        for (IVecInt vecWithFirst : subVec.subset(cardinal - 1)) {
            VecInt newVec = new VecInt();
            vecWithFirst.copyTo(newVec);
            newVec.insertFirst(this.get(0));
            liste.add(newVec);
        }
        for (IVecInt vecWithoutFirst : subVec.subset(cardinal)) {
            liste.add(vecWithoutFirst);
        }
        IVecInt[] result = new VecInt[liste.size()];
        for (int i = 0; i < liste.size(); ++i) {
            result[i] = (IVecInt)liste.get(i);
        }
        return result;
    }
}

