/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import net.fabricmc.loader.util.sat4j.core.LiteralsUtils;
import net.fabricmc.loader.util.sat4j.minisat.constraints.cnf.Lits;
import net.fabricmc.loader.util.sat4j.minisat.core.Constr;
import net.fabricmc.loader.util.sat4j.minisat.core.ILits;
import net.fabricmc.loader.util.sat4j.minisat.core.Propagatable;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.UnitPropagationListener;

public abstract class BinaryClause
implements Propagatable,
Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    private final ILits voc;
    protected int head;
    protected int tail;

    public BinaryClause(IVecInt ps, ILits voc) {
        assert (ps.size() == 2);
        this.head = ps.get(0);
        this.tail = ps.get(1);
        this.voc = voc;
        this.activity = 0.0;
    }

    public void calcReason(int p, IVecInt outReason) {
        if (this.voc.isFalsified(this.head)) {
            outReason.push(LiteralsUtils.neg(this.head));
        }
        if (this.voc.isFalsified(this.tail)) {
            outReason.push(LiteralsUtils.neg(this.tail));
        }
    }

    public void remove(UnitPropagationListener upl) {
        this.voc.watches(LiteralsUtils.neg(this.head)).remove(this);
        this.voc.watches(LiteralsUtils.neg(this.tail)).remove(this);
    }

    public boolean simplify() {
        return this.voc.isSatisfied(this.head) || this.voc.isSatisfied(this.tail);
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, this);
        if (this.head == LiteralsUtils.neg(p)) {
            return s.enqueue(this.tail, this);
        }
        assert (this.tail == LiteralsUtils.neg(p));
        return s.enqueue(this.head, this);
    }

    public boolean locked() {
        return this.voc.getReason(this.head) == this || this.voc.getReason(this.tail) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append(Lits.toString(this.head));
        stb.append("[");
        stb.append(this.voc.valueToString(this.head));
        stb.append("]");
        stb.append(" ");
        stb.append(Lits.toString(this.tail));
        stb.append("[");
        stb.append(this.voc.valueToString(this.tail));
        stb.append("]");
        return stb.toString();
    }

    public int get(int i) {
        if (i == 0) {
            return this.head;
        }
        assert (i == 1);
        return this.tail;
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return 2;
    }

    public void assertConstraint(UnitPropagationListener s) {
        boolean ret = s.enqueue(this.head, this);
        assert (ret);
    }

    public void assertConstraintIfNeeded(UnitPropagationListener s) {
        if (this.voc.isFalsified(this.tail)) {
            boolean ret = s.enqueue(this.head, this);
            assert (ret);
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[]{this.head, this.tail};
        return tmp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            BinaryClause wcl = (BinaryClause)obj;
            return wcl.head == this.head && wcl.tail == this.tail;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        long sum = this.head + this.tail;
        return (int)sum / 2;
    }

    public void register() {
        this.voc.watch(LiteralsUtils.neg(this.head), this);
        this.voc.watch(LiteralsUtils.neg(this.tail), this);
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int p, IVecInt trail, IVecInt outReason) {
        this.calcReason(p, outReason);
    }
}

