/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.fabricmc.loader.util.sat4j.core.LiteralsUtils;
import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolverService;
import net.fabricmc.loader.util.sat4j.specs.Lbool;
import net.fabricmc.loader.util.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RupSearchListener<S extends ISolverService>
extends SearchListenerAdapter<S> {
    private static final long serialVersionUID = 1L;
    private PrintStream out;
    private final File file;

    public RupSearchListener(String filename) {
        this.file = new File(filename);
    }

    @Override
    public void init(S solverService) {
        try {
            this.out = new PrintStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            this.out = System.out;
        }
    }

    @Override
    public void end(Lbool result) {
        if (result == Lbool.FALSE) {
            this.out.println("0");
            this.out.close();
        } else {
            this.out.close();
            this.file.delete();
        }
    }

    @Override
    public void learn(IConstr c) {
        for (int i = 0; i < c.size(); ++i) {
            this.out.print(LiteralsUtils.toDimacs(c.get(i)));
            this.out.print(" ");
        }
        this.out.println("0");
    }

    @Override
    public void learnUnit(int p) {
        this.out.print(p);
        this.out.println(" 0");
    }
}

