/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.GUIModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.ProducerEnvironment;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class RecordingTemplateControlView {
    private final Composite m_container;

    public RecordingTemplateControlView(Composite parent) {
        this.m_container = parent;
    }

    public void cleanCreate(XMLModel xmlModel) {
        this.cleanControls();
        this.createProducerControls(xmlModel, this.m_container);
        this.m_container.layout();
    }

    public void create(XMLModel xmlModel) {
        this.createProducerControls(xmlModel, this.m_container);
    }

    private void cleanControls() {
        Control[] controlArray = this.m_container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void createProducerControls(XMLModel xmlModel, Composite parent) {
        GUIModel uiModel = new GUIModel(xmlModel);
        uiModel.evaluate();
        for (ProducerEnvironment producer : uiModel.getProducers()) {
            if (producer.getWidgets().isEmpty()) continue;
            this.createProducer(parent, producer);
        }
    }

    private void createProducer(Composite parent, ProducerEnvironment producer) {
        Group g = this.getProducerGroup(parent, producer);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 7;
        g.setLayout((Layout)layout);
        this.addProducerDescription(producer, g);
        for (WidgetNode widget : producer.getWidgets()) {
            widget.create((Composite)g, layout.numColumns);
        }
    }

    private void addProducerDescription(ProducerEnvironment producer, Group g) {
        String prodDesc = producer.getDescription();
        if (prodDesc != null && prodDesc.length() > 0) {
            Label prodDescLabel = new Label((Composite)g, 0);
            prodDescLabel.setText(producer.getDescription());
            GridData gd = new GridData(16384, 0x1000000, true, false, 3, 1);
            prodDescLabel.setLayoutData((Object)gd);
        }
    }

    private Group getProducerGroup(Composite parent, ProducerEnvironment producer) {
        String producerText = this.getDescriptionName(producer);
        Group g = new Group(parent, 0);
        g.setText(producerText);
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        return g;
    }

    private String getDescriptionName(ProducerEnvironment producer) {
        if (producer.getName().length() > 0) {
            return producer.getName();
        }
        return producer.getURI();
    }
}

