/*
 * Decompiled with CFR 0.152.
 */
package ab.api.recipe.lexicon;

import ab.api.AdvancedBotanyAPI;
import ab.api.recipe.RecipeAdvancedPlate;
import ab.client.core.ClientHelper;
import ab.common.lib.register.BlockListAB;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class AdvancedPlateCraftPage
extends PageRecipe {
    private static final ResourceLocation plateOverlay = new ResourceLocation("botania:textures/gui/petalOverlay.png");
    private RecipeAdvancedPlate recipe;
    private final ItemStack resultStack;
    int ticksElapsed = 0;

    public AdvancedPlateCraftPage(LexiconEntry entry, ItemStack stack) {
        this(entry, stack, "");
    }

    public AdvancedPlateCraftPage(LexiconEntry entry, ItemStack stack, String str) {
        super(str);
        this.resultStack = stack;
        this.refreshRecipe(entry, stack);
    }

    public ItemStack getResult() {
        return this.resultStack;
    }

    public void refreshRecipe(LexiconEntry entry, ItemStack stack) {
        RecipeAdvancedPlate rec = null;
        for (RecipeAdvancedPlate recipe : AdvancedBotanyAPI.advancedPlateRecipes) {
            if (stack == null || recipe.getOutput() == null || !recipe.getOutput().func_77969_a(stack)) continue;
            rec = recipe;
            break;
        }
        if (rec == null) {
            entry.pages.remove((Object)this);
        }
        this.recipe = rec;
    }

    public void onPageAdded(LexiconEntry entry, int index) {
        LexiconRecipeMappings.map((ItemStack)this.recipe.getOutput(), (LexiconEntry)entry, (int)index);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        this.renderItemAtGridPos(gui, 3, 0, this.recipe.getOutput(), false);
        this.renderItemAtGridPos(gui, 2, 1, new ItemStack(BlockListAB.blockABPlate), false);
        List<ItemStack> inputs = this.recipe.getInputs();
        int degreePerInput = (int)(360.0f / (float)inputs.size());
        float currentDegree = ConfigHandler.lexiconRotatingItems ? (GuiScreen.func_146272_n() ? (float)this.ticksElapsed : (float)this.ticksElapsed + ClientTickHandler.partialTicks) : 0.0f;
        for (ItemStack obj : inputs) {
            ItemStack copy = obj.func_77946_l();
            if (copy.func_77960_j() == Short.MAX_VALUE) {
                copy.func_77964_b(0);
            }
            this.renderItemAtAngle(gui, currentDegree, copy);
            currentDegree += (float)degreePerInput;
        }
        this.renderManaBar(gui, mx, my);
        render.func_110577_a(plateOverlay);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderManaBar(IGuiLexiconEntry gui, int mx, int my) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        String manaUsage = StatCollector.func_74838_a((String)"botaniamisc.manaUsage");
        font.func_78276_b(manaUsage, gui.getLeft() + gui.getWidth() / 2 - font.func_78256_a(manaUsage) / 2, gui.getTop() + 105, 0x66000000);
        int x = gui.getLeft() + gui.getWidth() / 2 - 50;
        int y = gui.getTop() + 120;
        String stopStr = StatCollector.func_74838_a((String)"botaniamisc.shiftToStopSpin");
        ClientHelper.renderPoolManaBar(x, y - 5, 2334172, 1.0f, this.recipe.getManaUsage());
        boolean unicode = font.func_82883_a();
        font.func_78264_a(true);
        font.func_78276_b(stopStr, x + 49 - font.func_78256_a(stopStr) / 2, y + 18, -1728053248);
        font.func_78264_a(unicode);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        ++this.ticksElapsed;
    }

    public List<ItemStack> getDisplayedRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.recipe.getOutput());
        return list;
    }
}

