/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.api.IRenderHud;
import ab.common.lib.register.BlockListAB;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileMod;

public class TileLebethronCore
extends TileMod
implements IRenderHud {
    protected int tick;
    protected Block block;
    protected int meta;
    protected boolean validTree;

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        mb.addComponent(0, 1, 0, BlockListAB.blockLebethron, 4);
        mb.addComponent(0, 0, 0, BlockListAB.blockLebethron, 0);
        mb.addComponent(0, 2, 0, BlockListAB.blockLebethron, 0);
        mb.addComponent(0, 3, 0, BlockListAB.blockLebethron, 0);
        mb.addComponent(0, 4, 0, BlockListAB.blockLebethron, 0);
        mb.addComponent(0, 5, 0, BlockListAB.blockLebethron, 0);
        mb.setRenderOffset(0, 1, 0);
        return mb.makeSet();
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick <= 0) {
                this.updateStructure();
                if (this.validTree && this.getBlock() != null) {
                    this.spawnLeaves();
                    this.tick = 40;
                }
            } else {
                --this.tick;
            }
        } else if (this.field_145850_b.field_73012_v.nextBoolean()) {
            Botania.proxy.sparkleFX(this.field_145850_b, (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + Math.random(), (double)this.field_145849_e + Math.random(), 0.5f, 1.0f, 0.5f, (float)Math.random() * 2.0f, 2);
        }
    }

    public boolean getValidTree() {
        return this.validTree;
    }

    public void updateStructure() {
        boolean oldValidTree = this.validTree;
        this.validTree = this.hasValidTree();
        if (oldValidTree != this.validTree) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbtt) {
        nbtt.func_74768_a("blockID", Block.func_149682_b((Block)this.block));
        nbtt.func_74768_a("blockMeta", this.meta);
        nbtt.func_74768_a("tick", this.tick);
        nbtt.func_74757_a("validTree", this.validTree);
    }

    public void readCustomNBT(NBTTagCompound nbtt) {
        this.block = Block.func_149729_e((int)nbtt.func_74762_e("blockID"));
        this.meta = nbtt.func_74762_e("blockMeta");
        this.tick = nbtt.func_74762_e("tick");
        this.validTree = nbtt.func_74767_n("validTree");
    }

    public boolean setBlock(EntityPlayer player, Block block, int meta) {
        if (this.block == null) {
            this.block = block;
            this.meta = meta;
            return true;
        }
        if (Block.func_149680_a((Block)this.block, (Block)block) && this.meta == meta) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            Vec3 vec3 = player.func_70676_i(1.0f).func_72432_b();
            EntityItem entityitem = new EntityItem(this.field_145850_b, player.field_70165_t + vec3.field_72450_a, player.field_70163_u + (double)1.2f, player.field_70161_v + vec3.field_72449_c, new ItemStack(this.block, 1, this.meta));
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
        this.block = block;
        this.meta = meta;
        return true;
    }

    public Block getBlock() {
        if (!Block.func_149680_a((Block)this.block, (Block)Blocks.field_150350_a) && this.block != null) {
            return this.block;
        }
        return null;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean hasValidTree() {
        if (!this.checkBlock(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) {
            return false;
        }
        for (int i = 1; i <= 4; ++i) {
            if (this.checkBlock(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + i, this.field_145849_e))) continue;
            return false;
        }
        return true;
    }

    boolean checkBlock(Block block, int meta) {
        return block == BlockListAB.blockLebethron && meta == 0;
    }

    private void spawnLeaves() {
        int i;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y < 5; ++y) {
                    this.setBlock(this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y + 2, this.field_145849_e + z);
                }
            }
        }
        this.setBlock(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
        this.setBlock(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
        this.setBlock(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d + 7, this.field_145849_e);
        this.setBlock(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d + 7, this.field_145849_e);
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 7, this.field_145849_e + 1);
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 7, this.field_145849_e - 1);
        for (i = 0; i <= 3; ++i) {
            this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 6 + i, this.field_145849_e);
        }
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 2);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + 3, this.field_145849_e - 2);
            this.setBlock(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e - 2);
        }
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - 2);
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 2);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + 3, this.field_145849_e + 2);
            this.setBlock(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + 4, this.field_145849_e + 2);
        }
        this.setBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + 2);
        this.setBlock(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 2, this.field_145849_e);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 3, this.field_145849_e + i);
            this.setBlock(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 4, this.field_145849_e + i);
        }
        this.setBlock(this.field_145850_b, this.field_145851_c + 2, this.field_145848_d + 5, this.field_145849_e);
        this.setBlock(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 2, this.field_145849_e);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 3, this.field_145849_e + i);
            this.setBlock(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 4, this.field_145849_e + i);
        }
        this.setBlock(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d + 5, this.field_145849_e);
    }

    private void setBlock(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(10) <= 8) {
            return;
        }
        if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a && y < 256) {
            world.func_147465_d(x, y, z, this.block, this.meta, 3);
        }
    }

    @Override
    public void renderHud(Minecraft mc, ScaledResolution res) {
        if (!this.validTree) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        ItemStack stack = this.getBlock() != null ? new ItemStack(this.block, 1, this.meta) : new ItemStack((Block)Blocks.field_150362_t);
        int x = res.func_78326_a() / 2 - 7;
        int y = res.func_78328_b() / 2 + 12;
        Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + 18), (int)(y + 18), (int)0x44000000);
        Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x44000000);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, stack, x, y);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        boolean unicode = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(true);
        if (this.getBlock() != null) {
            mc.field_71466_p.func_78261_a("\u2713", x + 10, y + 9, 19456);
            mc.field_71466_p.func_78261_a("\u2713", x + 10, y + 8, 774669);
        } else {
            mc.field_71466_p.func_78261_a("\u2717", x + 10, y + 9, 0x4C0000);
            mc.field_71466_p.func_78261_a("\u2717", x + 10, y + 8, 13764621);
        }
        mc.field_71466_p.func_78264_a(unicode);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }
}

