/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.relic;

import ab.AdvancedBotany;
import ab.client.core.ClientHelper;
import ab.common.item.relic.ItemModRelic;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemTalismanHiddenRiches
extends ItemModRelic {
    protected static List<TileEntityChest> chestList = new ArrayList<TileEntityChest>();
    protected static final ResourceLocation glowTexture = new ResourceLocation("ab:textures/misc/glow3.png");
    protected static final int segmentCount = 11;
    protected static final int maxSegmentCount = 16;

    public ItemTalismanHiddenRiches() {
        super("talismanHiddenRiches");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        super.func_77663_a(stack, world, entity, pos, equipped);
        if (entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean eqLastTick = ItemTalismanHiddenRiches.wasEquipped(stack);
            if (!equipped && eqLastTick) {
                ItemTalismanHiddenRiches.setEquipped(stack, equipped);
            }
            if (!eqLastTick && equipped) {
                ItemTalismanHiddenRiches.setEquipped(stack, equipped);
                int angles = 360;
                int segAngles = angles / 16;
                float shift = (float)segAngles / 2.0f * 11.0f;
                ItemTalismanHiddenRiches.setRotationBase(stack, ItemTalismanHiddenRiches.getCheckingAngle((EntityLivingBase)entity) - shift);
            }
            if (world.field_72995_K && equipped) {
                for (int i = 0; i < 11; ++i) {
                    TileEntityChest chest = ItemTalismanHiddenRiches.getChestForSegment(i);
                    if (chest == null) continue;
                    chest.field_145986_n = chest.field_145989_m;
                    float lidAngel = chest.field_145989_m;
                    if (i == ItemTalismanHiddenRiches.getOpenChest(stack) && chest.field_145989_m < 1.0f) {
                        if (lidAngel == 0.0f) {
                            Minecraft.func_71410_x().field_71441_e.func_72980_b(player.field_70165_t, player.field_70163_u - 0.5, player.field_70161_v, "random.chestopen", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                        }
                        chest.field_145989_m = Math.min(1.0f, lidAngel + 0.1f);
                        continue;
                    }
                    if (i == ItemTalismanHiddenRiches.getOpenChest(stack) || !(lidAngel > 0.0f)) continue;
                    if ((int)(lidAngel * 10.0f) == 5) {
                        Minecraft.func_71410_x().field_71441_e.func_72980_b(player.field_70165_t, player.field_70163_u - 0.5, player.field_70161_v, "random.chestclosed", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                    }
                    chest.field_145989_m = Math.max(0.0f, lidAngel - 0.1f);
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int segment = ItemTalismanHiddenRiches.getSegmentLookedAt(stack, (EntityLivingBase)player);
        if (segment == -1) {
            return stack;
        }
        ItemTalismanHiddenRiches.setOpenChest(stack, segment);
        player.openGui((Object)AdvancedBotany.instance, 0, world, 0, 0, 0);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = entityClientPlayerMP.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemTalismanHiddenRiches) {
            this.render(stack, (EntityPlayer)entityClientPlayerMP, event.partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        GL11.glPushMatrix();
        float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glTranslated((double)(posX - RenderManager.field_78725_b), (double)(posY - RenderManager.field_78726_c), (double)(posZ - RenderManager.field_78723_d));
        float base = ItemTalismanHiddenRiches.getRotationBase(stack);
        int angles = 360;
        int segAngles = angles / 16;
        float shift = base - (float)segAngles / 2.0f * 11.0f;
        float u = 1.0f;
        float v = 0.25f;
        float s = 3.2f;
        float m = 0.8f;
        float y = v * 6.0f;
        float y0 = 0.0f;
        int segmentLookedAt = ItemTalismanHiddenRiches.getSegmentLookedAt(stack, (EntityLivingBase)player);
        for (int seg = 0; seg < 11; ++seg) {
            ClientHelper.setLightmapTextureCoords();
            float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(s * m), (float)-0.75f, (float)0.0f);
            double worldTime = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks + (float)seg * 2.75f;
            GL11.glTranslated((double)0.375, (double)(Math.sin(worldTime / 8.0) / 20.0), (double)-0.375);
            float scale = 0.75f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            TileEntityChest chest = ItemTalismanHiddenRiches.getChestForSegment(seg);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)chest, 0.0, 0.0, 0.0, partialTicks);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float a = alpha;
            if (segmentLookedAt == seg) {
                a += 0.3f;
                y0 = -y;
            }
            if (seg % 2 == 0) {
                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)a);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            ItemTalismanHiddenRiches item = (ItemTalismanHiddenRiches)stack.func_77973_b();
            mc.field_71446_o.func_110577_a(item.getGlowTexture(stack, seg));
            tess.func_78382_b();
            for (int i = 0; i < segAngles; ++i) {
                float ang = (float)(i + seg * segAngles) + shift;
                double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)s;
                double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, (double)u, (double)v);
                tess.func_78374_a(xp, (double)y0, zp, (double)u, 0.0);
                xp = Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                zp = Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp, (double)y0, zp, 0.0, 0.0);
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, 0.0, (double)v);
            }
            y0 = 0.0f;
            tess.func_78381_a();
            GL11.glPopMatrix();
            ClientHelper.setLightmapTextureCoords();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private ResourceLocation getGlowTexture(ItemStack stack, int seg) {
        return glowTexture;
    }

    protected static int getSegmentLookedAt(ItemStack stack, EntityLivingBase player) {
        float yaw = ItemTalismanHiddenRiches.getCheckingAngle(player, ItemTalismanHiddenRiches.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 16;
        for (int seg = 0; seg < 11; ++seg) {
            float calcAngle = seg * segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    protected static float getCheckingAngle(EntityLivingBase player, float base) {
        float angle;
        float yaw = MathHelper.func_76142_g((float)player.field_70177_z) + 90.0f;
        int angles = 360;
        int segAngles = angles / 16;
        float shift = (float)segAngles / 2.0f * 11.0f;
        if (yaw < 0.0f) {
            yaw = 360.0f + yaw;
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) > 360.0f) {
            angle %= 360.0f;
        }
        return angle;
    }

    protected static float getCheckingAngle(EntityLivingBase player) {
        return ItemTalismanHiddenRiches.getCheckingAngle(player, 0.0f);
    }

    public static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"equipped", (boolean)equipped);
    }

    public static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"equipped", (boolean)false);
    }

    public static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat((ItemStack)stack, (String)"rotationBase", (float)rotation);
    }

    public static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat((ItemStack)stack, (String)"rotationBase", (float)0.0f);
    }

    public static void setOpenChest(ItemStack stack, int segment) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"openChest", (int)segment);
    }

    public static int getOpenChest(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"openChest", (int)-1);
    }

    public static TileEntityChest getChestForSegment(int segment) {
        if (chestList.isEmpty()) {
            for (int i = 0; i < 11; ++i) {
                chestList.add(new TileEntityChest());
            }
        }
        if (segment < 0 || segment > 11) {
            return null;
        }
        return chestList.get(segment);
    }

    public static void setChestLoot(ItemStack stack, ItemStack[] loot, int segment) {
        NBTTagList nbtList = new NBTTagList();
        int i = -1;
        for (ItemStack item : loot) {
            ++i;
            if (item == null) continue;
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74774_a("slot", (byte)i);
            item.func_77946_l().func_77955_b(cmp);
            nbtList.func_74742_a((NBTBase)cmp);
        }
        ItemNBTHelper.setList((ItemStack)stack, (String)("chestLoot" + segment), (NBTTagList)nbtList);
    }

    public static ItemStack[] getChestLoot(ItemStack stack, int segment) {
        if (segment >= 11) {
            return null;
        }
        ItemStack[] loot = new ItemStack[27];
        NBTTagList nbtList = ItemNBTHelper.getList((ItemStack)stack, (String)("chestLoot" + segment), (int)10, (boolean)false);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound cmp = nbtList.func_150305_b(i);
            byte slotCount = cmp.func_74771_c("slot");
            if (slotCount < 0) continue;
            loot[slotCount] = ItemStack.func_77949_a((NBTTagCompound)cmp);
        }
        return loot;
    }
}

