/*
 * Decompiled with CFR 0.152.
 */
package ab.common.minetweaker;

import ab.api.recipe.lexicon.AdvancedPlateCraftPage;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;

@ZenClass(value="mods.advBotany.AdvancedPlatePage")
public class AdvancedPlatePageMT {
    @ZenMethod
    public static void refresh(String name, int page) {
        List entries = BotaniaAPI.getAllEntries();
        LexiconEntry entry = null;
        LexiconPage recipePage = null;
        for (int i = 0; i < entries.size(); ++i) {
            if (!((LexiconEntry)entries.get(i)).getUnlocalizedName().equalsIgnoreCase(name)) continue;
            entry = (LexiconEntry)entries.get(i);
            recipePage = (LexiconPage)((LexiconEntry)entries.get((int)i)).pages.get(page);
            break;
        }
        if (entry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry");
            return;
        }
        if (recipePage == null || !(recipePage instanceof AdvancedPlateCraftPage)) {
            MineTweakerAPI.getLogger().logError("Cannot find Advanced Plate Craft Page");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RefreshPage(entry, (AdvancedPlateCraftPage)recipePage, page));
    }

    @ZenMethod
    public static void addPage(String name, int page, IItemStack stack, String text) {
        LexiconEntry entry = null;
        ItemStack result = MineTweakerMC.getItemStack((IItemStack)stack);
        List entries = BotaniaAPI.getAllEntries();
        for (int i = 0; i < entries.size(); ++i) {
            if (!((LexiconEntry)entries.get(i)).getUnlocalizedName().equalsIgnoreCase(name)) continue;
            entry = (LexiconEntry)entries.get(i);
            break;
        }
        if (entry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry");
            return;
        }
        page = Math.min(entry.pages.size(), page);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(entry, result, page, text));
    }

    private static class AddPage
    implements IUndoableAction {
        private LexiconEntry entry;
        private ItemStack result;
        private int pageCount;
        private String name;

        public AddPage(LexiconEntry lexEntry, ItemStack stack, int count, String text) {
            this.entry = lexEntry;
            this.result = stack;
            this.pageCount = count;
            this.name = text;
        }

        public void apply() {
            this.entry.pages.add(this.pageCount, new AdvancedPlateCraftPage(this.entry, this.result, this.name));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.entry.pages.remove(this.pageCount);
        }

        public String describe() {
            return "Add Advanced Plate Page for item " + this.result.func_82833_r();
        }

        public String describeUndo() {
            return "Remove Advanced Plate Page for item " + this.result.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RefreshPage
    implements IUndoableAction {
        private LexiconEntry entry;
        private AdvancedPlateCraftPage page;
        private ItemStack result;
        private int pageCount;

        public RefreshPage(LexiconEntry lexEntry, AdvancedPlateCraftPage abPlatePage, int count) {
            this.page = abPlatePage;
            this.result = abPlatePage.getResult();
            this.pageCount = count;
            this.entry = lexEntry;
        }

        public void apply() {
            this.page.refreshRecipe(this.entry, this.result);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (LexiconPage page : this.entry.pages) {
                AdvancedPlateCraftPage platePage;
                if (!(page instanceof AdvancedPlateCraftPage) || !(platePage = (AdvancedPlateCraftPage)page).getResult().func_77969_a(this.result)) continue;
                return;
            }
            this.entry.pages.add(this.pageCount, new AdvancedPlateCraftPage(this.entry, this.result, this.page.getUnlocalizedName()));
        }

        public String describe() {
            return "Refresh Advanced Plate Page for item " + this.result.func_82833_r();
        }

        public String describeUndo() {
            return "Undo Refresh Advanced Plate Page for item " + this.result.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

