/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.betterfps;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class BetterMathHelper {
    public static final LinkedHashMap<String, String> helpers = new LinkedHashMap();
    public static final LinkedHashMap<String, String> displayHelpers = new LinkedHashMap();
    public static Configuration CONFIG;
    public static Property CONFIG_ALGORITHM;
    public static String ALGORITHM_NAME;
    public static String ALGORITHM_CLASS;

    public static void loadConfig() {
        File configFile = new File("config", "betterfps.cfg");
        CONFIG = new Configuration(configFile);
        CONFIG_ALGORITHM = CONFIG.get("betterfps", "algorithm", "rivens-full");
        CONFIG_ALGORITHM.setRequiresMcRestart(true);
        String v = "";
        for (String s : helpers.keySet()) {
            v = v + ", " + s;
        }
        BetterMathHelper.CONFIG_ALGORITHM.comment = "The algorithm to be used.\nValues: " + v.substring(2);
        String[] validValues = new String[displayHelpers.size()];
        int i = 0;
        Iterator<String> i$ = displayHelpers.values().iterator();
        while (i$.hasNext()) {
            String s;
            validValues[i] = s = i$.next();
            ++i;
        }
        CONFIG_ALGORITHM.setValidValues(validValues);
        ALGORITHM_NAME = CONFIG_ALGORITHM.getString();
        ALGORITHM_CLASS = helpers.get(ALGORITHM_NAME);
        CONFIG.save();
    }

    static {
        helpers.put("vanilla", "VanillaMath");
        helpers.put("rivens", "RivensMath");
        helpers.put("taylors", "TaylorMath");
        helpers.put("libgdx", "LibGDXMath");
        helpers.put("rivens-full", "RivensFullMath");
        helpers.put("rivens-half", "RivensHalfMath");
        helpers.put("java", "JavaMath");
        helpers.put("random", "RandomMath");
        displayHelpers.put("vanilla", "Vanilla Algorithm");
        displayHelpers.put("rivens", "Riven's Algorithm");
        displayHelpers.put("taylors", "Taylor's Algorithm");
        displayHelpers.put("libgdx", "LibGDX's Algorithm");
        displayHelpers.put("rivens-full", "Riven's \"Full\" Algorithm");
        displayHelpers.put("rivens-half", "Riven's \"Half\" Algorithm");
        displayHelpers.put("java", "Java Math");
        displayHelpers.put("random", "Random Math");
    }
}

