/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.block.BlockTeleposer;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RitualEffectSphereCreator
extends RitualEffect {
    public static int MAX_RADIUS = 32;
    private static final int terraeDrain = 1;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.func_72820_D() % 1L != 0L) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            ItemStack invStack1;
            ItemStack invStack2;
            TileEntity tile = world.func_147438_o(x, y + 1, z);
            if (!(tile instanceof IInventory)) {
                return;
            }
            int negYOffset = 0;
            int radius = 0;
            IInventory inv = (IInventory)tile;
            int invSize = inv.func_70302_i_();
            if (invSize < 1) {
                return;
            }
            if (invSize >= 2 && (invStack2 = inv.func_70301_a(1)) != null) {
                negYOffset = invStack2.field_77994_a;
            }
            if ((invStack1 = inv.func_70301_a(0)) == null) {
                return;
            }
            radius = invStack1.field_77994_a;
            if (radius <= 0) {
                return;
            }
            if (negYOffset < (radius = Math.min(radius, MAX_RADIUS)) + 3) {
                negYOffset = radius + 3;
            }
            Int3 lastPos = this.getLastPosition(ritualStone.getCustomRitualTag(), radius);
            int j = -radius;
            int i = -radius;
            int k = -radius;
            if (lastPos != null) {
                j = Math.min(radius, Math.max(-radius, lastPos.yCoord));
                i = Math.min(radius, Math.max(-radius, lastPos.xCoord));
                k = Math.min(radius, Math.max(-radius, lastPos.zCoord));
            }
            int yP = y + negYOffset;
            int yN = y - negYOffset;
            boolean incrementNext = false;
            while (i <= radius) {
                while (j <= radius) {
                    while (k <= radius) {
                        if ((float)(i * i + j * j + k * k) >= ((float)radius + 0.5f) * ((float)radius + 0.5f)) {
                            ++k;
                            continue;
                        }
                        if (incrementNext) {
                            this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, j, k));
                            return;
                        }
                        Block blk = world.func_147439_a(x + i, yP + j, z + k);
                        if (world.func_147437_c(x + i, yN + j, z + k) || !world.func_147437_c(x + i, yP + j, z + k) && !SpellHelper.isBlockFluid(blk)) {
                            ++k;
                            continue;
                        }
                        if (BlockTeleposer.swapBlocks(this, world, world, x + i, yN + j, z + k, x + i, yP + j, z + k, false, 2)) {
                            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
                            if (this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 1, true)) {
                                world.func_147465_d(x + i, yN + j, z + k, Blocks.field_150346_d, 0, 2);
                            }
                        }
                        this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, j, k));
                        incrementNext = true;
                        ++k;
                    }
                    k = -radius;
                    ++j;
                }
                j = -radius;
                ++i;
            }
            ritualStone.setActive(false);
            this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, j, k));
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostSphereIsland[1];
    }

    public Int3 getLastPosition(NBTTagCompound tag, int radius) {
        if (tag != null && tag.func_74767_n("hasWorked")) {
            return Int3.readFromNBT(tag);
        }
        return new Int3(-radius, -radius, -radius);
    }

    public void setLastPosition(NBTTagCompound tag, Int3 pos) {
        if (tag != null) {
            pos.writeToNBT(tag);
            tag.func_74757_a("hasWorked", true);
        }
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> magneticRitual = new ArrayList<RitualComponent>();
        magneticRitual.add(new RitualComponent(1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, 2, 3));
        magneticRitual.add(new RitualComponent(-2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, -2, 3));
        magneticRitual.add(new RitualComponent(2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, 2, 2));
        magneticRitual.add(new RitualComponent(-2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, -2, 5));
        return magneticRitual;
    }
}

