/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenStalagmite
extends WorldGenerator {
    protected final List<WeightedRandomBlock> cluster;
    protected final WeightedRandomBlock[] baseBlock;
    protected final WeightedRandomBlock[] genBlock;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int heightMod = 5;
    public int genSize = 0;
    public boolean smooth = false;
    public boolean fat = true;
    public boolean altSinc = false;

    public WorldGenStalagmite(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2, List<WeightedRandomBlock> list3) {
        this.cluster = list;
        this.baseBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
        this.genBlock = list3.toArray(new WeightedRandomBlock[list3.size()]);
    }

    protected int getHeight(int n, int n2, int n3, Random random, int n4) {
        int n5;
        int n6;
        if (this.smooth) {
            if ((n * n + n2 * n2) * 4 >= n3 * n3 * 5) {
                return 0;
            }
            double d = (this.altSinc ? 600.0f : (this.fat ? 1.0f : 0.5f) * 400.0f) / (float)n3;
            double d2 = (double)n * d / Math.PI;
            double d3 = d2 * d2;
            d2 = (double)n2 * d / Math.PI;
            d2 = Math.sqrt(d3 + d2 * d2) * Math.PI / 180.0;
            if (this.altSinc && d2 < 1.0) {
                d2 = Math.sqrt((double)(n3 * 2) * d / Math.PI) * Math.PI / 180.0;
            }
            if (d2 == 0.0) {
                return n4;
            }
            if (!this.altSinc) {
                return (int)Math.round((double)n4 * (this.fat ? Math.sin(d2) / d2 : Math.sin(d2 *= Math.PI) / d2));
            }
            double d4 = Math.sin(d2) / d2;
            return (int)Math.round((double)n4 * (d4 * 2.0 + Math.sin(d2 *= Math.PI * 4) / d2) / 2.0 + random.nextGaussian() * 0.75);
        }
        int n7 = n < 0 ? -n : n;
        int n8 = n6 = n2 < 0 ? -n2 : n2;
        int n9 = this.fat ? (n7 < n6 ? n6 + n7 / 2 : n7 + n6 / 2) : (n5 = n7 + n6);
        if (n5 == 0) {
            return n4;
        }
        int n10 = 1 + n4 / n5;
        return n10 > 1 ? random.nextInt(n10) : 0;
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        int n4;
        while (world.func_147437_c(n, n2, n3) && n2 > 0) {
            --n2;
        }
        if (!WorldGenMinableCluster.canGenerateInBlock(world, n, n2++, n3, this.baseBlock)) {
            return false;
        }
        int n5 = (this.heightVariance > 0 ? random.nextInt(this.heightVariance) : 0) + this.minHeight;
        int n6 = n4 = this.genSize > 0 ? this.genSize : n5 / this.heightMod;
        if (this.sizeVariance > 0) {
            n4 += random.nextInt(this.sizeVariance);
        }
        boolean bl = false;
        for (int i = -n4; i <= n4; ++i) {
            for (int j = -n4; j <= n4; ++j) {
                if (!WorldGenMinableCluster.canGenerateInBlock(world, n + i, n2 - 1, n3 + j, this.baseBlock)) continue;
                int n7 = this.getHeight(i, j, n4, random, n5);
                for (int k = 0; k < n7; ++k) {
                    bl |= WorldGenMinableCluster.generateBlock(world, n + i, n2 + k, n3 + j, this.genBlock, this.cluster);
                }
            }
        }
        return bl;
    }
}

