/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.TextureDataHolder;
import cofh.repack.codechicken.lib.render.TextureFX;
import cofh.repack.codechicken.lib.render.TextureSpecial;
import cofh.repack.codechicken.lib.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class SpriteSheetManager {
    private static HashMap<String, SpriteSheet> spriteSheets = new HashMap();

    public static SpriteSheet getSheet(ResourceLocation resourceLocation) {
        return SpriteSheetManager.getSheet(16, 16, resourceLocation);
    }

    public static SpriteSheet getSheet(int n, int n2, ResourceLocation resourceLocation) {
        SpriteSheet spriteSheet = spriteSheets.get(resourceLocation.toString());
        if (spriteSheet == null) {
            spriteSheet = new SpriteSheet(n, n2, resourceLocation);
            spriteSheets.put(resourceLocation.toString(), spriteSheet);
        }
        return spriteSheet;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpriteSheet
    implements TextureUtils.IIconSelfRegister {
        private int tilesX;
        private int tilesY;
        private ArrayList<Integer> newSprites = new ArrayList();
        private TextureSpecial[] sprites;
        private ResourceLocation resource;
        private TextureDataHolder texture;
        private int spriteWidth;
        private int spriteHeight;
        public int atlasIndex;

        private SpriteSheet(int n, int n2, ResourceLocation resourceLocation) {
            this.tilesX = n;
            this.tilesY = n2;
            this.resource = resourceLocation;
            this.sprites = new TextureSpecial[n * n2];
        }

        public void requestIndicies(int ... nArray) {
            for (int n : nArray) {
                this.setupSprite(n);
            }
        }

        @Override
        public void registerIcons(IIconRegister iIconRegister) {
            TextureMap textureMap = (TextureMap)iIconRegister;
            if (TextureUtils.refreshTexture(textureMap, this.resource.func_110623_a())) {
                this.reloadTexture();
                for (TextureSpecial textureSpecial : this.sprites) {
                    if (textureSpecial == null) continue;
                    textureMap.setTextureEntry(textureSpecial.func_94215_i(), (TextureAtlasSprite)textureSpecial);
                }
            } else {
                for (int n : this.newSprites) {
                    textureMap.setTextureEntry(this.sprites[n].func_94215_i(), (TextureAtlasSprite)this.sprites[n]);
                }
            }
            this.newSprites.clear();
        }

        public TextureSpecial setupSprite(int n) {
            if (this.sprites[n] == null) {
                String string = this.resource + "_" + n;
                this.sprites[n] = new TextureSpecial(string).baseFromSheet(this, n);
                this.newSprites.add(n);
            }
            return this.sprites[n];
        }

        private void reloadTexture() {
            this.texture = TextureUtils.loadTexture(this.resource);
            this.spriteWidth = this.texture.width / this.tilesX;
            this.spriteHeight = this.texture.height / this.tilesY;
        }

        public IIcon getSprite(int n) {
            TextureSpecial textureSpecial = this.sprites[n];
            if (textureSpecial == null) {
                throw new IllegalArgumentException("Sprite at index: " + n + " from texture file " + this.resource + " was not preloaded.");
            }
            return textureSpecial;
        }

        public TextureDataHolder createSprite(int n) {
            int n2 = n % this.tilesX;
            int n3 = n / this.tilesX;
            TextureDataHolder textureDataHolder = new TextureDataHolder(this.spriteWidth, this.spriteHeight);
            TextureUtils.copySubImg(this.texture.data, this.texture.width, n2 * this.spriteWidth, n3 * this.spriteHeight, this.spriteWidth, this.spriteHeight, textureDataHolder.data, this.spriteWidth, 0, 0);
            return textureDataHolder;
        }

        public int spriteWidth() {
            return this.spriteWidth;
        }

        public int spriteHeight() {
            return this.spriteHeight;
        }

        public TextureSpecial bindTextureFX(int n, TextureFX textureFX) {
            return this.setupSprite(n).addTextureFX(textureFX);
        }

        public SpriteSheet selfRegister(int n) {
            TextureUtils.addIconRegistrar(this);
            return this;
        }

        @Override
        public int atlasIndex() {
            return this.atlasIndex;
        }
    }
}

