/*
 * Decompiled with CFR 0.152.
 */
package net.divinerpg.entities.vanilla.projectile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityShooterBullet
extends EntityThrowable {
    protected float damage;
    private short xTile;
    private short yTile;
    private short zTile;
    private Block inTile;
    private String throwerName;
    private EntityLivingBase thrower;

    public EntityShooterBullet(World world) {
        super(world);
    }

    public EntityShooterBullet(World world, EntityLivingBase entity, float damage, Item ammo) {
        super(world, entity);
        this.damage = damage;
        this.field_70180_af.func_75692_b(17, (Object)("divinerpg:textures/items/" + ammo.func_77658_a().replace("item.", "") + ".png"));
    }

    public EntityShooterBullet(World world, EntityLivingBase entity, float damage, String texture) {
        super(world, entity);
        this.damage = damage;
        this.field_70180_af.func_75692_b(17, (Object)texture);
    }

    public EntityShooterBullet(World world, double posX, double posY, double posZ, float damage, String texture) {
        super(world, posX, posY, posZ);
        this.damage = damage;
        this.field_70180_af.func_75692_b(17, (Object)texture);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    public int getBulletId() {
        return this.field_70180_af.func_75679_c(17);
    }

    protected void func_70184_a(MovingObjectPosition position) {
        if (position.field_72308_g != null) {
            position.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74777_a("xTile", this.xTile);
        tag.func_74777_a("yTile", this.yTile);
        tag.func_74777_a("zTile", this.zTile);
        tag.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        tag.func_74774_a("shake", (byte)this.field_70191_b);
        tag.func_74774_a("inGround", (byte)(this.field_70193_a ? 1 : 0));
        tag.func_74778_a("texture", this.field_70180_af.func_75681_e(17));
        tag.func_74776_a("damage", this.damage);
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        tag.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.xTile = tag.func_74765_d("xTile");
        this.yTile = tag.func_74765_d("yTile");
        this.zTile = tag.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(tag.func_74771_c("inTile") & 0xFF));
        this.field_70191_b = tag.func_74771_c("shake") & 0xFF;
        this.field_70193_a = tag.func_74771_c("inGround") == 1;
        this.throwerName = tag.func_74779_i("ownerName");
        this.field_70180_af.func_75692_b(17, (Object)tag.func_74779_i("texture"));
        this.damage = tag.func_74760_g("damage");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
    }

    public String getTextureName() {
        return this.field_70180_af.func_75681_e(17);
    }
}

