/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockChorusPlant;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChorusFlower
extends Block
implements IConfigurable {
    @SideOnly(value=Side.CLIENT)
    private IIcon deadIcon;

    public BlockChorusFlower() {
        super(Material.field_151585_k);
        this.func_149711_c(0.4f);
        this.func_149675_a(true);
        this.func_149672_a(field_149766_f);
        this.func_149658_d("chorus_flower");
        this.func_149663_c(Utils.getUnlocalisedName("chorus_flower"));
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
    }

    public void func_149670_a(World w, int x, int y, int z, Entity ent) {
        if (ent instanceof EntityArrow) {
            w.func_147480_a(x, y, z, true);
        }
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityDragon);
    }

    public int func_149645_b() {
        return RenderIDs.CHORUS_FLOWER;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta >= 5 ? this.deadIcon : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.deadIcon = reg.func_94245_a("chorus_flower_dead");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        world.func_147464_a(x, y, z, (Block)this, 5);
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 5) {
            return;
        }
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        } else if (world.func_147437_c(x, y + 1, z)) {
            boolean canGrowUp = false;
            boolean isSegmentOnEndstone = false;
            Block lowerBlock = world.func_147439_a(x, y - 1, z);
            if (BlockChorusPlant.canPlaceOn(lowerBlock)) {
                canGrowUp = true;
            } else if (lowerBlock == ModBlocks.chorus_plant) {
                int height;
                int par8 = 1;
                for (height = 0; height < 4; ++height) {
                    Block b = world.func_147439_a(x, y - (par8 + 1), z);
                    if (b != ModBlocks.chorus_plant) {
                        if (!BlockChorusPlant.canPlaceOn(b)) break;
                        isSegmentOnEndstone = true;
                        break;
                    }
                    ++par8;
                }
                height = 4;
                if (isSegmentOnEndstone) {
                    ++height;
                }
                if (par8 < 2 || rand.nextInt(height) >= par8) {
                    canGrowUp = true;
                }
            } else if (lowerBlock.isAir((IBlockAccess)world, x, y - 1, z)) {
                canGrowUp = true;
            }
            if (canGrowUp && BlockChorusFlower.areAllNeighborsEmpty(world, x, y + 1, z, ForgeDirection.DOWN) && world.func_147437_c(x, y + 2, z)) {
                world.func_147449_b(x, y, z, ModBlocks.chorus_plant);
                this.setFlower(world, x, y + 1, z, meta);
            } else if (meta < 4) {
                int tries = rand.nextInt(4);
                boolean grew = false;
                if (isSegmentOnEndstone) {
                    ++tries;
                }
                for (int i = 0; i < tries; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
                    int xx = x + dir.offsetX;
                    int yy = y + dir.offsetY;
                    int zz = z + dir.offsetZ;
                    if (!world.func_147437_c(xx, yy, zz) || !BlockChorusFlower.areAllNeighborsEmpty(world, xx, yy, zz, dir.getOpposite())) continue;
                    this.setFlower(world, xx, yy, zz, meta + 1);
                    grew = true;
                }
                if (grew) {
                    world.func_147465_d(x, y, z, ModBlocks.chorus_plant, 0, 3);
                } else {
                    this.setFlower(world, x, y, z, 5);
                }
            } else if (meta == 4) {
                this.setFlower(world, x, y, z, 5);
            }
        }
    }

    private void setFlower(World world, int x, int y, int z, int age) {
        world.func_147465_d(x, y, z, (Block)this, age, 3);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.18:block.chorus_flower." + (age < 5 ? "grow" : "death"), 1.0f, 1.0f);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, false);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return BlockChorusFlower.canPlantStay(world, x, y, z);
    }

    public static boolean canPlantStay(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block != ModBlocks.chorus_plant && !BlockChorusPlant.canPlaceOn(block)) {
            if (block.isAir((IBlockAccess)world, x, y - 1, z)) {
                int adjecentCount = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Block adjecentBlock = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                    if (adjecentBlock == ModBlocks.chorus_plant) {
                        ++adjecentCount;
                        continue;
                    }
                    if (adjecentBlock.isAir((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                    return false;
                }
                return adjecentCount == 1;
            }
            return false;
        }
        return true;
    }

    public static boolean areAllNeighborsEmpty(World world, int x, int y, int z, ForgeDirection skip) {
        ForgeDirection[] horizontal;
        for (ForgeDirection enumfacing : horizontal = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
            if (enumfacing == skip || world.func_147437_c(x + enumfacing.offsetX, y + enumfacing.offsetY, z + enumfacing.offsetZ)) continue;
            return false;
        }
        return true;
    }

    public static void generatePlant(World worldIn, int x, int y, int z, Random rand, int p_185603_3_) {
        worldIn.func_147449_b(x, y, z, ModBlocks.chorus_plant);
        BlockChorusFlower.growTreeRecursive(worldIn, x, y, z, x, y, z, rand, p_185603_3_, 0);
    }

    private static void growTreeRecursive(World worldIn, int x, int y, int z, int x1, int y1, int z1, Random rand, int p_185601_4_, int p_185601_5_) {
        int i = rand.nextInt(4) + 1;
        if (p_185601_5_ == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            if (!BlockChorusFlower.areAllNeighborsEmpty(worldIn, x, y + j + 1, z, null)) {
                return;
            }
            worldIn.func_147449_b(x, y + j + 1, z, ModBlocks.chorus_plant);
        }
        boolean flag = false;
        if (p_185601_5_ < 4) {
            int l = rand.nextInt(4);
            if (p_185601_5_ == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                ForgeDirection[] horizontal = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
                ForgeDirection ForgeDirection2 = horizontal[rand.nextInt(horizontal.length)];
                int bp1x = x + ForgeDirection2.offsetX;
                int bp1y = y + ForgeDirection2.offsetY + i;
                int bp1z = z + ForgeDirection2.offsetZ;
                if (Math.abs(bp1x - x1) >= p_185601_4_ || Math.abs(bp1z - z1) >= p_185601_4_ || !worldIn.func_147437_c(bp1x, bp1y, bp1z) || !worldIn.func_147437_c(bp1x, bp1y - 1, bp1z) || !BlockChorusFlower.areAllNeighborsEmpty(worldIn, bp1x, bp1y, bp1z, ForgeDirection2.getOpposite())) continue;
                flag = true;
                worldIn.func_147449_b(bp1x, bp1y, bp1z, ModBlocks.chorus_plant);
                BlockChorusFlower.growTreeRecursive(worldIn, bp1x, bp1y, bp1z, x1, y1, z1, rand, p_185601_4_, p_185601_5_ + 1);
            }
        }
        if (!flag) {
            worldIn.func_147465_d(x, y + i, z, ModBlocks.chorus_flower, 5, 2);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.func_149718_j(world, x, y, z);
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enableChorusFruit;
    }
}

