/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.block.ItemBanner;
import ganymedes01.etfuturum.lib.EnumColour;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.tileentities.TileEntityBanner;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class BannerPatternHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)Utils.getConainerName("banner"));
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "banner", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (!outputId.equals("banner")) {
            super.loadCraftingRecipes(outputId, results);
            return;
        }
        for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
            if (!pattern.hasValidCrafting()) continue;
            if (pattern.hasCraftingStack()) {
                this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", " z "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), "dye", Character.valueOf('z'), new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE))).setRandomPermutations());
                this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", "   "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE))).setRandomPermutations());
                continue;
            }
            String[] layers = pattern.getCraftingLayers();
            String[] layersCopy = new String[]{layers[0], layers[1], layers[2]};
            for (int i = 0; i < 3; ++i) {
                String newLayer = layersCopy[i].replaceFirst(" ", "x");
                if (newLayer.equals(layersCopy[i])) continue;
                layersCopy[i] = newLayer;
                break;
            }
            this.arecipes.add(new CachedPatternRecipe(pattern, layersCopy, Arrays.asList(Character.valueOf('#'), "dye", Character.valueOf('x'), new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE))));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() != Item.func_150898_a((Block)ModBlocks.banner)) {
            return;
        }
        NBTTagCompound nbt = ItemBanner.getSubTag(result, "BlockEntityTag", false);
        if (nbt != null && nbt.func_150297_b("Patterns", 9)) {
            NBTTagList patterns = nbt.func_150295_c("Patterns", 10);
            for (int i = 0; i < patterns.func_74745_c(); ++i) {
                EnumColour colour;
                NBTTagCompound patternNBT = patterns.func_150305_b(i);
                TileEntityBanner.EnumBannerPattern pattern = TileEntityBanner.EnumBannerPattern.getPatternByID(patternNBT.func_74779_i("Pattern"));
                if (pattern == null) continue;
                ItemStack copy = new ItemStack(ModBlocks.banner, 1, result.func_77960_j());
                copy.func_77982_d(null);
                EnumColour enumColour = colour = patternNBT.func_74764_b("Color") ? EnumColour.fromDamage(patternNBT.func_74762_e("Color")) : null;
                if (!pattern.hasValidCrafting()) continue;
                if (pattern.hasCraftingStack()) {
                    if (colour != null) {
                        this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", " z "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), colour.getOreName(), Character.valueOf('z'), copy)));
                        continue;
                    }
                    this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", "   "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), copy)));
                    continue;
                }
                String[] layers = pattern.getCraftingLayers();
                String[] layersCopy = new String[]{layers[0], layers[1], layers[2]};
                for (int j = 0; j < 3; ++j) {
                    String newLayer = layersCopy[j].replaceFirst(" ", "x");
                    if (newLayer.equals(layersCopy[j])) continue;
                    layersCopy[j] = newLayer;
                    break;
                }
                this.arecipes.add(new CachedPatternRecipe(pattern, layersCopy, Arrays.asList(Character.valueOf('#'), colour == null ? "dye" : colour.getOreName(), Character.valueOf('x'), copy)));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == Item.func_150898_a((Block)ModBlocks.banner) && TileEntityBanner.getPatterns(ingredient) < 6) {
            for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
                if (!pattern.hasValidCrafting()) continue;
                if (pattern.hasCraftingStack()) {
                    ItemStack banner = ingredient.func_77946_l();
                    banner.field_77994_a = 1;
                    this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", " z "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), "dye", Character.valueOf('z'), banner)));
                    this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", "   "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), banner)));
                    continue;
                }
                String[] layers = pattern.getCraftingLayers();
                String[] layersCopy = new String[]{layers[0], layers[1], layers[2]};
                for (int i = 0; i < 3; ++i) {
                    String newLayer = layersCopy[i].replaceFirst(" ", "x");
                    if (newLayer.equals(layersCopy[i])) continue;
                    layersCopy[i] = newLayer;
                    break;
                }
                ItemStack banner = ingredient.func_77946_l();
                banner.field_77994_a = 1;
                this.arecipes.add(new CachedPatternRecipe(pattern, layersCopy, Arrays.asList(Character.valueOf('#'), "dye", Character.valueOf('x'), banner)));
            }
        } else {
            for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
                if (!pattern.hasValidCrafting()) continue;
                if (pattern.hasCraftingStack() && OreDictionary.itemMatches((ItemStack)pattern.getCraftingStack(), (ItemStack)ingredient, (boolean)false)) {
                    ItemStack banner = new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE);
                    banner.field_77994_a = 1;
                    this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", " z "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), "dye", Character.valueOf('z'), banner)).setRandomPermutations());
                    this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", "   "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), banner)).setRandomPermutations());
                    continue;
                }
                for (int oreID : OreDictionary.getOreIDs((ItemStack)ingredient)) {
                    String oreName = OreDictionary.getOreName((int)oreID);
                    if (!this.isNameDye(oreName)) continue;
                    if (pattern.hasCraftingStack()) {
                        ItemStack banner = new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE);
                        banner.field_77994_a = 1;
                        this.arecipes.add(new CachedPatternRecipe(pattern, new String[]{"   ", "xy ", " z "}, Arrays.asList(Character.valueOf('x'), pattern.getCraftingStack(), Character.valueOf('y'), oreName, Character.valueOf('z'), banner)));
                        continue;
                    }
                    String[] layers = pattern.getCraftingLayers();
                    String[] layersCopy = new String[]{layers[0], layers[1], layers[2]};
                    for (int i = 0; i < 3; ++i) {
                        String newLayer = layersCopy[i].replaceFirst(" ", "x");
                        if (newLayer.equals(layersCopy[i])) continue;
                        layersCopy[i] = newLayer;
                        break;
                    }
                    ItemStack banner = new ItemStack(ModBlocks.banner, 1, Short.MAX_VALUE);
                    banner.field_77994_a = 1;
                    this.arecipes.add(new CachedPatternRecipe(pattern, layersCopy, Arrays.asList(Character.valueOf('#'), oreName, Character.valueOf('x'), banner)));
                }
            }
        }
    }

    EnumColour getEnumColour(ItemStack stack) {
        for (String ore : Utils.getOreNames(stack)) {
            for (EnumColour colour : EnumColour.values()) {
                if (!ore.equals(colour.getOreName())) continue;
                return colour;
            }
        }
        return null;
    }

    private boolean isNameDye(String name) {
        for (String dye : ModRecipes.ore_dyes) {
            if (!dye.equals(name)) continue;
            return true;
        }
        return false;
    }

    public class CachedPatternRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        private final TileEntityBanner.EnumBannerPattern pattern;
        private boolean randomPermutations;

        public CachedPatternRecipe(TileEntityBanner.EnumBannerPattern pattern, String[] grid, List<Object> inputs) {
            super((TemplateRecipeHandler)BannerPatternHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.randomPermutations = false;
            this.pattern = pattern;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    char c = grid[y].charAt(x);
                    if (c == ' ') continue;
                    Object input = inputs.get(inputs.indexOf(Character.valueOf(c)) + 1);
                    if (input instanceof String) {
                        input = OreDictionary.getOres((String)((String)input));
                    }
                    PositionedStack stack = new PositionedStack(input, 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public CachedPatternRecipe setRandomPermutations() {
            this.randomPermutations = true;
            return this;
        }

        public List<PositionedStack> getIngredients() {
            if (this.randomPermutations) {
                return this.getCycledIngredients(BannerPatternHandler.this.cycleticks / 20, this.ingredients);
            }
            for (PositionedStack stack : this.ingredients) {
                if (stack.items.length <= 1) continue;
                stack.setPermutationToRender(BannerPatternHandler.this.cycleticks / 20 % stack.items.length);
            }
            return this.ingredients;
        }

        public PositionedStack getResult() {
            NBTTagList nbttaglist;
            NBTTagCompound nbt;
            EnumColour colour = null;
            ItemStack banner = null;
            for (PositionedStack stack : this.getIngredients()) {
                if (stack.item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.banner)) {
                    banner = stack.item.func_77946_l();
                }
                if (colour != null) continue;
                colour = BannerPatternHandler.this.getEnumColour(stack.item);
            }
            if (banner == null) {
                banner = new ItemStack(ModBlocks.banner);
            }
            if ((nbt = ItemBanner.getSubTag(banner, "BlockEntityTag", true)).func_150297_b("Patterns", 9)) {
                nbttaglist = nbt.func_150295_c("Patterns", 10);
            } else {
                nbttaglist = new NBTTagList();
                nbt.func_74782_a("Patterns", (NBTBase)nbttaglist);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("Pattern", this.pattern.getPatternID());
            if (colour != null) {
                nbttagcompound.func_74768_a("Color", colour.getDamage());
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            return new PositionedStack((Object)banner, 119, 24);
        }
    }
}

