/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.tileentity;

import com.google.common.primitives.SignedBytes;
import ganymedes01.etfuturum.client.model.ModelShulker;
import ganymedes01.etfuturum.client.renderer.entity.ShulkerRenderer;
import ganymedes01.etfuturum.tileentities.TileEntityShulkerBox;
import java.util.Random;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityShulkerBoxRenderer
extends TileEntitySpecialRenderer {
    public int tier = 0;
    private Random random;
    private RenderItem itemRenderer;
    private static float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
    private final ModelShulker modelShulker;

    public TileEntityShulkerBoxRenderer(ModelShulker p_i47216_1_) {
        this.modelShulker = p_i47216_1_;
        this.random = new Random();
        this.itemRenderer = new RenderItem(){

            public byte getMiniBlockCount(ItemStack stack, byte original) {
                return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 15) + 1));
            }

            public byte getMiniItemCount(ItemStack stack, byte original) {
                return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 7) + 1));
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public void renderTileEntityAt(TileEntityShulkerBox te, double x, double y, double z, float partialTicks, int destroyStage) {
        ForgeDirection enumfacing = ForgeDirection.UP;
        if (te.func_145830_o()) {
            byte facing = te.facing;
            enumfacing = ForgeDirection.values()[facing];
            this.tier = te.func_145832_p();
        }
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3008);
        if (destroyStage >= 0) {
            this.func_147499_a(DESTROY_STAGES[destroyStage]);
            GL11.glMatrixMode((int)5890);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GL11.glMatrixMode((int)5888);
        } else {
            this.func_147499_a(ShulkerRenderer.SHULKER_ENDERGOLEM_TEXTURES[te.color % ShulkerRenderer.SHULKER_ENDERGOLEM_TEXTURES.length + (te.field_145847_g == -1 ? 0 : te.field_145847_g % (TileEntityShulkerBox.tiers.length + 1) * 17)]);
        }
        GL11.glPushMatrix();
        if (destroyStage < 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)0.9995f, (float)0.9995f, (float)0.9995f);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (enumfacing) {
            case DOWN: {
                GL11.glTranslatef((float)0.0f, (float)2.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            default: {
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        this.modelShulker.base.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.0f, (float)(-te.func_190585_a(partialTicks) * 0.5f), (float)0.0f);
        GL11.glRotatef((float)(270.0f * te.func_190585_a(partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelShulker.lid.func_78785_a(0.0625f);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GL11.glMatrixMode((int)5890);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        if (te.func_145830_o() && te.type.getIsClear() && te.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            if (te.getTopItemStacks()[1] == null) {
                shift = 8;
                blockScale = 0.85f;
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            EntityItem customitem = new EntityItem(this.field_147501_a.field_147550_f);
            customitem.field_70290_d = 0.0f;
            for (ItemStack item : te.getTopItemStacks()) {
                if (shift > shifts.length) break;
                if (item == null) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)shiftX, (float)shiftY, (float)shiftZ);
                GL11.glRotatef((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopAttrib();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTicks) {
        this.renderTileEntityAt((TileEntityShulkerBox)te, x, y, z, partialTicks, -1);
    }
}

