/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration.configs;

import ganymedes01.etfuturum.EtFuturumMixinPlugin;
import ganymedes01.etfuturum.configuration.ConfigBase;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class ConfigMixins
extends ConfigBase {
    public static boolean endPortalFix;
    public static boolean fenceWallConnectFix;
    public static boolean furnaceCrackle;
    public static boolean stepHeightFix;
    static final String catBackport = "backported features";
    static final String catOptimization = "optimizations";
    static final String catFixes = "fixes";
    static final String catMisc = "misc";
    public static final String PATH;
    public static final ConfigMixins configInstance;
    public static boolean avoidDroppingItemsWhenClosing;
    public static boolean enableSpectatorMode;

    public ConfigMixins(File file) {
        super(file);
        this.setCategoryComment(catBackport, "Backports that can typically only have a clean implementation with mixins.");
        this.setCategoryComment(catOptimization, "Better implementations of existing features.\nThis is generally used when doing something through the Forge API would be slower or less practical than using a Mixin.");
        this.setCategoryComment(catFixes, "Fixes to vanilla issues which are necessary for backports.");
        this.setCategoryComment(catMisc, "Mixins that don't fit in any other category.");
        this.configCats.add(this.getCategory(catBackport));
        this.configCats.add(this.getCategory(catOptimization));
        this.configCats.add(this.getCategory(catFixes));
        this.configCats.add(this.getCategory(catMisc));
    }

    @Override
    protected void syncConfigOptions() {
        ConfigMixins cfg = configInstance;
        if (EtFuturumMixinPlugin.side == MixinEnvironment.Side.CLIENT) {
            furnaceCrackle = cfg.getBoolean("furnaceCrackle", catBackport, true, "(Client only) Allows vanilla furnaces to have crackling sounds.\nModified Client Classes: net.minecraft.block.BlockFurnace");
        }
        endPortalFix = cfg.getBoolean("endPortalFix", catBackport, true, "Makes the End Portal block (the actual portal, not the frame) have an item icon, proper hitbox and will not instantly destroy itself in other dimensions.\nModified classes: net.minecraft.block.BlockEndPortal");
        fenceWallConnectFix = cfg.getBoolean("fenceWallConnectFix", catBackport, true, "Makes vanilla fences connect to modded ones of the same material. Might have connection issue with mods that don't reference BlockFence super code.\nModified classes: net.minecraft.block.BlockFence net.minecraft.block.BlockWall");
        avoidDroppingItemsWhenClosing = cfg.getBoolean("avoidDroppingItemsWhenClosing", catBackport, false, "Experimental: avoid dropping items when closing an inventory, like in modern versions.\nModified Classes: net.minecraft.entity.player.EntityPlayerMP");
        enableSpectatorMode = cfg.getBoolean("enableSpectatorMode", catBackport, true, "VERY EXPERIMENTAL!\nModified Classes: net.minecraft.world.WorldSettings.GameType net.minecraft.entity.Entity net.minecraft.world.World net.minecraft.entity.player.EntityPlayer net.minecraft.network.NetHandlerPlayServer\nModified Client Classes: net.minecraft.client.renderer.EntityRenderer net.minecraft.entity.player.EntityPlayer net.minecraft.client.renderer.WorldRenderer");
        stepHeightFix = cfg.getBoolean("stepHeightFix", catFixes, true, "Makes the player able to step up even if a block would be above their head at the destination.\nModified classes: net.minecraft.entity.Entity");
    }

    static {
        PATH = ConfigBase.configDir + File.separator + "mixins.cfg";
        configInstance = new ConfigMixins(new File(Launch.minecraftHome, PATH));
    }
}

