/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.helpers.BlockAndMetadataMapping;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class DeepslateOreRegistry {
    private static final Map<Integer, BlockAndMetadataMapping> deepslateOres = new HashMap<Integer, BlockAndMetadataMapping>();
    private static final Map<Integer, BlockAndMetadataMapping> inputOres = new HashMap<Integer, BlockAndMetadataMapping>();

    public static void addOre(Block from, Block to) {
        DeepslateOreRegistry.addOre(from, 0, to, 0);
    }

    public static void addOre(Block from, int fromMeta, Block to, int toMeta) {
        BlockAndMetadataMapping inputMapping = new BlockAndMetadataMapping(from, fromMeta);
        deepslateOres.put(inputMapping.hashCode(), new BlockAndMetadataMapping(to, toMeta));
        inputOres.put(inputMapping.hashCode(), inputMapping);
    }

    public static boolean hasOre(Block block) {
        return DeepslateOreRegistry.hasOre(block, 0);
    }

    public static boolean hasOre(Block block, int meta) {
        return deepslateOres.containsKey(block.hashCode() + meta);
    }

    public static BlockAndMetadataMapping getOre(Block block) {
        return DeepslateOreRegistry.getOre(block, 0);
    }

    public static BlockAndMetadataMapping getOre(Block block, int meta) {
        return deepslateOres.get(block.hashCode() + meta);
    }

    public static Map<Integer, BlockAndMetadataMapping> getOreMap() {
        return deepslateOres;
    }

    public static void init() {
        if (ConfigBlocksItems.enableDeepslateOres) {
            for (Map.Entry<Integer, BlockAndMetadataMapping> entry : DeepslateOreRegistry.getOreMap().entrySet()) {
                Block oreDeep;
                Block oreNorm = inputOres.get(entry.getKey()).getBlock();
                if (Block.field_149771_c.func_148750_c((Object)oreNorm) == null || oreNorm == Blocks.field_150350_a || Block.field_149771_c.func_148750_c((Object)(oreDeep = entry.getValue().getBlock())) == null || oreDeep == Blocks.field_150350_a) continue;
                ItemStack stackNorm = new ItemStack(oreNorm, 1, inputOres.get(entry.getKey()).getMeta());
                ItemStack stackDeep = new ItemStack(oreDeep, 1, entry.getValue().getMeta());
                for (String oreName : EtFuturum.getOreStrings(stackNorm)) {
                    OreDictionary.registerOre((String)oreName.replace("Vanillastone", "Deepslate"), (ItemStack)stackDeep.func_77946_l());
                }
                if (FurnaceRecipes.func_77602_a().func_151395_a(stackNorm) == null) continue;
                GameRegistry.addSmelting((ItemStack)stackDeep, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(stackNorm), (float)FurnaceRecipes.func_77602_a().func_151398_b(stackNorm));
            }
            inputOres.clear();
        }
    }
}

