/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static String getUnlocalisedName(String name) {
        return "etfuturum." + name;
    }

    public static String getBlockTexture(String name) {
        return "etfuturum:" + name;
    }

    public static String getItemTexture(String name) {
        return "etfuturum:" + name;
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(path);
    }

    public static String getConainerName(String name) {
        return "container.etfuturum." + name;
    }

    public static <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> cls) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!cls.isInstance(tile)) {
            return null;
        }
        return (T)tile;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static void loadItemStacksFromNBT(NBTTagList tag, ItemStack[] stacks) {
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tag.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= stacks.length) continue;
            stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public static NBTTagList writeItemStacksToNBT(ItemStack[] stacks) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stacks[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static NBTTagCompound createUUIDTag(UUID uuid) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74772_a("M", uuid.getMostSignificantBits());
        nbttagcompound.func_74772_a("L", uuid.getLeastSignificantBits());
        return nbttagcompound;
    }

    public static UUID getUUIDFromTag(NBTTagCompound tag) {
        return new UUID(tag.func_74763_f("M"), tag.func_74763_f("L"));
    }

    public static MovingObjectPosition forwardsRaycast(Entity p_188802_0_, boolean p_188802_1_, boolean p_188802_2_, Entity p_188802_3_) {
        double d0 = p_188802_0_.field_70165_t;
        double d1 = p_188802_0_.field_70163_u;
        double d2 = p_188802_0_.field_70161_v;
        double d3 = p_188802_0_.field_70159_w;
        double d4 = p_188802_0_.field_70181_x;
        double d5 = p_188802_0_.field_70179_y;
        World world = p_188802_0_.field_70170_p;
        Vec3 vec3d = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(d0 + d3), (double)(d1 + d4), (double)(d2 + d5));
        MovingObjectPosition raytraceresult = world.func_147447_a(vec3d, vec3d1, false, true, false);
        if (p_188802_1_) {
            if (raytraceresult != null) {
                vec3d1 = Vec3.func_72443_a((double)raytraceresult.field_72307_f.field_72450_a, (double)raytraceresult.field_72307_f.field_72448_b, (double)raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = world.func_72839_b(p_188802_0_, p_188802_0_.field_70121_D.func_72321_a(d3, d4, d5).func_72314_b(1.0, 1.0, 1.0));
            double d6 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d7;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition raytraceresult1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || !p_188802_2_ && entity1.func_70028_i(p_188802_3_) || entity1.field_70145_X || (raytraceresult1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)0.3f, (double)0.3f, (double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d7 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                entity = entity1;
                d6 = d7;
            }
            if (entity != null) {
                raytraceresult = new MovingObjectPosition(entity);
            }
        }
        return raytraceresult;
    }

    public static final void rotateTowardsMovement(Entity p_188803_0_, float p_188803_1_) {
        double d0 = p_188803_0_.field_70159_w;
        double d1 = p_188803_0_.field_70181_x;
        double d2 = p_188803_0_.field_70179_y;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        p_188803_0_.field_70177_z = (float)(Utils.atan2(d2, d0) * 57.29577951308232) + 90.0f;
        p_188803_0_.field_70125_A = (float)(Utils.atan2(f, d1) * 57.29577951308232) - 90.0f;
        while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C < -180.0f) {
            p_188803_0_.field_70127_C -= 360.0f;
        }
        while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C >= 180.0f) {
            p_188803_0_.field_70127_C += 360.0f;
        }
        while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B < -180.0f) {
            p_188803_0_.field_70126_B -= 360.0f;
        }
        while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B >= 180.0f) {
            p_188803_0_.field_70126_B += 360.0f;
        }
        p_188803_0_.field_70125_A = p_188803_0_.field_70127_C + (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C) * p_188803_1_;
        p_188803_0_.field_70177_z = p_188803_0_.field_70126_B + (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B) * p_188803_1_;
    }

    public static double atan2(double p_181159_0_, double p_181159_2_) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        double FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
        double[] ASINE_TAB = new double[257];
        double[] COS_TAB = new double[257];
        for (int j = 0; j < 257; ++j) {
            double d0 = (double)j / 256.0;
            double d1 = Math.asin(d0);
            COS_TAB[j] = Math.cos(d1);
            ASINE_TAB[j] = d1;
        }
        double d0 = p_181159_2_ * p_181159_2_ + p_181159_0_ * p_181159_0_;
        if (Double.isNaN(d0)) {
            return Double.NaN;
        }
        boolean bl = flag = p_181159_0_ < 0.0;
        if (flag) {
            p_181159_0_ = -p_181159_0_;
        }
        boolean bl2 = flag1 = p_181159_2_ < 0.0;
        if (flag1) {
            p_181159_2_ = -p_181159_2_;
        }
        boolean bl3 = flag2 = p_181159_0_ > p_181159_2_;
        if (flag2) {
            double d1 = p_181159_2_;
            p_181159_2_ = p_181159_0_;
            p_181159_0_ = d1;
        }
        double d9 = Utils.fastInvSqrt(d0);
        p_181159_2_ *= d9;
        double d2 = FRAC_BIAS + (p_181159_0_ *= d9);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = ASINE_TAB[i];
        double d4 = COS_TAB[i];
        double d5 = d2 - FRAC_BIAS;
        double d6 = p_181159_0_ * d4 - p_181159_2_ * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static double fastInvSqrt(double p_181161_0_) {
        double d0 = 0.5 * p_181161_0_;
        long i = Double.doubleToRawLongBits(p_181161_0_);
        i = 6910469410427058090L - (i >> 1);
        p_181161_0_ = Double.longBitsToDouble(i);
        p_181161_0_ *= 1.5 - d0 * p_181161_0_ * p_181161_0_;
        return p_181161_0_;
    }
}

