/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockStoneSlab2;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.entities.EntityNewBoat;
import ganymedes01.etfuturum.lib.EnumColour;
import ganymedes01.etfuturum.recipes.BlastFurnaceRecipes;
import ganymedes01.etfuturum.recipes.crafting.RecipeAddPattern;
import ganymedes01.etfuturum.recipes.crafting.RecipeDuplicatePattern;
import ganymedes01.etfuturum.recipes.crafting.RecipeDyedShulkerBox;
import ganymedes01.etfuturum.recipes.crafting.RecipeTippedArrow;
import ganymedes01.etfuturum.recipes.crafting.ShapedEtFuturumRecipe;
import ganymedes01.etfuturum.recipes.crafting.ShapelessEtFuturumRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.StringUtils;

public class ModRecipes {
    public static final String[] ore_dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    public static final String[] dye_names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};

    public static void init() {
        if (ConfigBlocksItems.enableBanners) {
            RecipeSorter.register((String)"etfuturum.RecipeDuplicatePattern", RecipeDuplicatePattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            RecipeSorter.register((String)"etfuturum.RecipeAddPattern", RecipeAddPattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        }
        RecipeSorter.register((String)"etfuturum:shaped", ShapedEtFuturumRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"etfuturum:shapeless", ShapelessEtFuturumRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
        ModRecipes.registerOreDictionary();
        ModRecipes.registerRecipes();
        ModRecipes.tweakRecipes();
    }

    private static void tweakRecipes() {
        if (ConfigBlocksItems.enableExtraVanillaSlabs) {
            ModRecipes.removeFirstRecipeFor((Block)Blocks.field_150333_U, 0);
        }
        if (ConfigBlocksItems.enableDoors) {
            Items.field_151135_aq.func_77625_d(64);
            Items.field_151139_aw.func_77625_d(64);
        }
        if (ConfigBlocksItems.enableFences) {
            ModRecipes.removeFirstRecipeFor(Blocks.field_150422_aJ);
            ModRecipes.removeFirstRecipeFor(Blocks.field_150386_bk);
        }
        if (ConfigBlocksItems.replaceOldBoats && ConfigBlocksItems.enableNewBoats) {
            ModRecipes.removeFirstRecipeFor(Items.field_151124_az);
            Items.field_151124_az.func_111206_d("minecraft:oak_boat");
            Items.field_151124_az.func_77655_b(Utils.getUnlocalisedName("oak_boat"));
        }
        if (ConfigFunctions.enableExtraBurnableBlocks) {
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150396_be, 5, 20);
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150422_aJ, 5, 20);
            Blocks.field_150480_ab.setFireInfo((Block)Blocks.field_150330_I, 60, 100);
        }
    }

    private static void registerOreDictionary() {
        int i;
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)Blocks.field_150486_ae));
        OreDictionary.registerOre((String)"bookshelfWood", (ItemStack)new ItemStack(Blocks.field_150342_X));
        OreDictionary.registerOre((String)"doorWood", (ItemStack)new ItemStack(Items.field_151135_aq));
        OreDictionary.registerOre((String)"trapdoorWood", (Block)Blocks.field_150415_aT);
        OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack(Blocks.field_150422_aJ));
        OreDictionary.registerOre((String)"fenceGateWood", (ItemStack)new ItemStack(Blocks.field_150396_be));
        OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(Blocks.field_150471_bO));
        OreDictionary.registerOre((String)"pressurePlateWood", (ItemStack)new ItemStack(Blocks.field_150452_aw));
        OreDictionary.registerOre((String)"doorIron", (ItemStack)new ItemStack(Items.field_151139_aw));
        OreDictionary.registerOre((String)"buttonStone", (ItemStack)new ItemStack(Blocks.field_150430_aB));
        OreDictionary.registerOre((String)"pressurePlateStone", (ItemStack)new ItemStack(Blocks.field_150456_au));
        OreDictionary.registerOre((String)"pressurePlateIron", (ItemStack)new ItemStack(Blocks.field_150443_bT));
        OreDictionary.registerOre((String)"pressurePlateGold", (ItemStack)new ItemStack(Blocks.field_150445_bS));
        OreDictionary.registerOre((String)"bowlWood", (ItemStack)new ItemStack(Items.field_151054_z));
        if (ConfigBlocksItems.enableIronNugget) {
            OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(ModItems.iron_nugget));
        }
        if (ConfigBlocksItems.enableMutton) {
            OreDictionary.registerOre((String)"foodMuttonraw", (ItemStack)new ItemStack(ModItems.raw_mutton));
            OreDictionary.registerOre((String)"listAllmeatraw", (ItemStack)new ItemStack(ModItems.raw_mutton));
            OreDictionary.registerOre((String)"listAllmuttonraw", (ItemStack)new ItemStack(ModItems.raw_mutton));
            OreDictionary.registerOre((String)"foodMuttoncooked", (ItemStack)new ItemStack(ModItems.cooked_mutton));
            OreDictionary.registerOre((String)"listAllmeatcooked", (ItemStack)new ItemStack(ModItems.cooked_mutton));
            OreDictionary.registerOre((String)"listAllmuttoncooked", (ItemStack)new ItemStack(ModItems.cooked_mutton));
        }
        if (ConfigBlocksItems.enablePrismarine) {
            OreDictionary.registerOre((String)"shardPrismarine", (ItemStack)new ItemStack(ModItems.prismarine_shard));
            OreDictionary.registerOre((String)"crystalPrismarine", (ItemStack)new ItemStack(ModItems.prismarine_crystals));
            OreDictionary.registerOre((String)"blockPrismarine", (ItemStack)new ItemStack(ModBlocks.prismarine, 1, Short.MAX_VALUE));
        }
        if (ConfigBlocksItems.enableDoors) {
            for (i = 0; i < 5; ++i) {
                OreDictionary.registerOre((String)"doorWood", (ItemStack)new ItemStack(ModBlocks.doors[i]));
            }
        }
        if (ConfigBlocksItems.enableTrapdoors) {
            for (i = 0; i < 5; ++i) {
                OreDictionary.registerOre((String)"trapdoorWood", (Block)ModBlocks.trapdoors[i]);
            }
        }
        if (ConfigBlocksItems.enableFences) {
            for (i = 0; i < ModBlocks.fences.length; ++i) {
                OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack(ModBlocks.fences[i]));
            }
            for (i = 0; i < ModBlocks.gates.length; ++i) {
                OreDictionary.registerOre((String)"fenceGateWood", (ItemStack)new ItemStack(ModBlocks.gates[i]));
            }
        }
        if (ConfigBlocksItems.enableWoodRedstone) {
            for (i = 0; i < ModBlocks.buttons.length; ++i) {
                OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(ModBlocks.buttons[i]));
            }
            for (i = 0; i < ModBlocks.pressure_plates.length; ++i) {
                OreDictionary.registerOre((String)"pressurePlateWood", (ItemStack)new ItemStack(ModBlocks.pressure_plates[i]));
            }
        }
        if (ConfigBlocksItems.enableStones) {
            OreDictionary.registerOre((String)"stoneGranite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 1));
            OreDictionary.registerOre((String)"stoneDiorite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 3));
            OreDictionary.registerOre((String)"stoneAndesite", (ItemStack)new ItemStack(ModBlocks.stone, 1, 5));
            OreDictionary.registerOre((String)"stoneGranitePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 2));
            OreDictionary.registerOre((String)"stoneDioritePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 4));
            OreDictionary.registerOre((String)"stoneAndesitePolished", (ItemStack)new ItemStack(ModBlocks.stone, 1, 6));
        }
        if (ConfigBlocksItems.enableSlimeBlock) {
            OreDictionary.registerOre((String)"blockSlime", (ItemStack)new ItemStack(ModBlocks.slime));
        }
        if (ConfigBlocksItems.enableIronTrapdoor) {
            OreDictionary.registerOre((String)"trapdoorIron", (Block)ModBlocks.iron_trapdoor);
        }
        if (ConfigBlocksItems.enableBeetroot) {
            OreDictionary.registerOre((String)"cropBeetroot", (Item)ModItems.beetroot);
            OreDictionary.registerOre((String)"listAllseed", (Item)ModItems.beetroot_seeds);
            OreDictionary.registerOre((String)"seedBeetroot", (Item)ModItems.beetroot_seeds);
        }
        if (ConfigEntities.enableRabbit) {
            OreDictionary.registerOre((String)"foodRabbitraw", (ItemStack)new ItemStack(ModItems.raw_rabbit));
            OreDictionary.registerOre((String)"listAllmeatraw", (ItemStack)new ItemStack(ModItems.raw_rabbit));
            OreDictionary.registerOre((String)"listAllrabbitraw", (ItemStack)new ItemStack(ModItems.raw_rabbit));
            OreDictionary.registerOre((String)"foodRabbitcooked", (ItemStack)new ItemStack(ModItems.cooked_rabbit));
            OreDictionary.registerOre((String)"listAllmeatcooked", (ItemStack)new ItemStack(ModItems.cooked_rabbit));
            OreDictionary.registerOre((String)"listAllrabbitcooked", (ItemStack)new ItemStack(ModItems.cooked_rabbit));
        }
        if (ConfigBlocksItems.enableChorusFruit) {
            OreDictionary.registerOre((String)"brickEndStone", (Block)ModBlocks.end_bricks);
        }
        if (ConfigBlocksItems.enableNetherite) {
            OreDictionary.registerOre((String)"ingotNetherite", (Item)ModItems.netherite_ingot);
            OreDictionary.registerOre((String)"scrapNetherite", (Item)ModItems.netherite_scrap);
            OreDictionary.registerOre((String)"oreNetherite", (Block)ModBlocks.ancient_debris);
            OreDictionary.registerOre((String)"blockNetherite", (Block)ModBlocks.netherite_block);
        }
        for (i = 0; i < 4; ++i) {
            if (ConfigBlocksItems.enableStrippedLogs) {
                OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.log_stripped, 1, i));
                OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.log2_stripped, 1, i));
                if (ConfigBlocksItems.enableBarkLogs) {
                    OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.wood_stripped, 1, i));
                    OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.wood2_stripped, 1, i));
                }
            }
            if (!ConfigBlocksItems.enableBarkLogs) continue;
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.log_bark, 1, i));
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ModBlocks.log2_bark, 1, i));
        }
        if (ConfigBlocksItems.enableNewDyes) {
            OreDictionary.registerOre((String)"dye", (ItemStack)new ItemStack(ModItems.new_dye, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(ModItems.new_dye, 1, 0));
            OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(ModItems.new_dye, 1, 1));
            OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(ModItems.new_dye, 1, 2));
            OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack(ModItems.new_dye, 1, 3));
        }
        if (ConfigBlocksItems.enableCopper) {
            OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ModBlocks.copper_ore, 1, 0));
            OreDictionary.registerOre((String)"ingotCopper", (ItemStack)new ItemStack(ModItems.copper_ingot, 1, 0));
            OreDictionary.registerOre((String)"blockCopper", (ItemStack)new ItemStack(ModBlocks.copper_block, 1, 0));
            OreDictionary.registerOre((String)"blockCopperCut", (ItemStack)new ItemStack(ModBlocks.copper_block, 1, 4));
        }
        if (ConfigBlocksItems.enableDeepslate) {
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(ModBlocks.cobbled_deepslate, 1, 0));
        }
        if (ConfigBlocksItems.enableRawOres) {
            if (ConfigBlocksItems.enableCopper) {
                OreDictionary.registerOre((String)"rawCopper", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 0));
                OreDictionary.registerOre((String)"blockRawCopper", (ItemStack)new ItemStack(ModBlocks.raw_ore_block, 1, 0));
            }
            OreDictionary.registerOre((String)"rawIron", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 1));
            OreDictionary.registerOre((String)"blockRawIron", (ItemStack)new ItemStack(ModBlocks.raw_ore_block, 1, 1));
            OreDictionary.registerOre((String)"rawGold", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 2));
            OreDictionary.registerOre((String)"blockRawGold", (ItemStack)new ItemStack(ModBlocks.raw_ore_block, 1, 2));
        }
        if (ConfigFunctions.registerRawItemAsOre && ConfigBlocksItems.enableRawOres) {
            if (ConfigBlocksItems.enableCopper) {
                OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 0));
            }
            OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 1));
            OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(ModItems.raw_ore, 1, 2));
        }
        if (ConfigBlocksItems.enablePigstep) {
            OreDictionary.registerOre((String)"record", (Item)ModItems.pigstep_record);
        }
        if (ConfigBlocksItems.enableOtherside) {
            OreDictionary.registerOre((String)"record", (Item)ModItems.otherside_record);
        }
        if (ConfigBlocksItems.enableAmethyst) {
            OreDictionary.registerOre((String)"gemAmethyst", (Item)ModItems.amethyst_shard);
            OreDictionary.registerOre((String)"blockGlassTinted", (ItemStack)new ItemStack(ModBlocks.tinted_glass, 1, 0));
        }
    }

    private static void registerRecipes() {
        int i;
        int i2;
        if (ConfigFunctions.enableStoneBrickRecipes) {
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150341_Y), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150395_bd));
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150395_bd));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150417_aV, 1, 3), "x", "x", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150333_U, 1, 5));
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150417_aV), (ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 2), (float)0.0f);
        }
        if (ConfigBlocksItems.enableSlimeBlock) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.slime), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151123_aH));
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151123_aH, 9), ModBlocks.slime);
        }
        if (ConfigBlocksItems.enableCoarseDirt) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.coarse_dirt, 4), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150346_d), Character.valueOf('y'), new ItemStack(Blocks.field_150351_n));
        }
        if (ConfigBlocksItems.enableMutton) {
            GameRegistry.addSmelting((Item)ModItems.raw_mutton, (ItemStack)new ItemStack(ModItems.cooked_mutton), (float)0.35f);
        }
        if (ConfigBlocksItems.enableIronNugget) {
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151042_j), "xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron");
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.iron_nugget, 9), "ingotIron");
        }
        if (ConfigBlocksItems.enableIronTrapdoor) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.iron_trapdoor), "xx", "xx", Character.valueOf('x'), "ingotIron");
        }
        if (ConfigBlocksItems.enableStones) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 2, 3), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150347_e), Character.valueOf('y'), "gemQuartz");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 4), "xx", "xx", Character.valueOf('x'), "stoneDiorite");
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.stone, 2, 5), new ItemStack(Blocks.field_150347_e), "stoneDiorite");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 6), "xx", "xx", Character.valueOf('x'), "stoneAndesite");
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.stone, 2, 1), "gemQuartz", "stoneDiorite");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone, 4, 2), "xx", "xx", Character.valueOf('x'), "stoneGranite");
            Block[] stairs = new Block[]{ModBlocks.granite_stairs, ModBlocks.polished_granite_stairs, ModBlocks.diorite_stairs, ModBlocks.polished_diorite_stairs, ModBlocks.andesite_stairs, ModBlocks.polished_andesite_stairs};
            for (i2 = 0; i2 < stairs.length; ++i2) {
                String dictName = "stone" + StringUtils.capitalize((String)((BlockStoneSlab2)ModBlocks.stone_slab).metaBlocks[i2 / 2 * 2]) + (i2 % 2 == 1 ? "Polished" : "");
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone_slab, 6, i2), "xxx", Character.valueOf('x'), dictName);
                ModRecipes.addShapedRecipe(new ItemStack(stairs[i2], 4), "x  ", "xx ", "xxx", Character.valueOf('x'), dictName);
                if (i2 % 2 != 1) continue;
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone_wall, 6, i2 == 5 ? 2 : (i2 == 3 ? 1 : 0)), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.stone, 1, i2));
            }
        }
        if (ConfigBlocksItems.enablePrismarine) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, 0), "xxx", "xyx", "xxx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "dyeBlack");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, 1), "xx", "xx", Character.valueOf('x'), "shardPrismarine");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine, 1, 2), "xxx", "xxx", "xxx", Character.valueOf('x'), "shardPrismarine");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.sea_lantern), "xyx", "yyy", "xyx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "crystalPrismarine");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.rough_prismarine_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.prismarine, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine_brick_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.prismarine, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.dark_prismarine_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.prismarine, 1, 2));
            GameRegistry.addRecipe((ItemStack)new ItemStack(ModBlocks.prismarine_wall, 6, 0), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.prismarine, 1, 0)});
            for (int i3 = 0; i3 < 3; ++i3) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.prismarine_slab, 6, i3), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.prismarine, 1, i3));
            }
            if (ConfigFunctions.enableRecipeForPrismarine && !Loader.isModLoaded((String)"Botania")) {
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.prismarine_shard, 4), "xy", "zx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dyeBlue", Character.valueOf('z'), "dyeGreen");
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.prismarine_crystals, 4), "xy", "yx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dustGlowstone");
            }
        }
        if (ConfigBlocksItems.enableExtraVanillaSlabs) {
            Block[] metaBlocks = new Block[]{Blocks.field_150348_b, Blocks.field_150341_Y, Blocks.field_150417_aV, Blocks.field_150322_A};
            for (i2 = 0; i2 < metaBlocks.length; ++i2) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.generic_slab, 6, i2), "xxx", Character.valueOf('x'), new ItemStack(metaBlocks[i2], 1, i2 != 0 ? i2 - 1 : i2));
            }
            ModRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150333_U, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_stone, 1, 0));
        }
        if (ConfigBlocksItems.enableExtraVanillaStairs) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stone_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150348_b, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.mossy_cobblestone_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150341_Y, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.mossy_stone_brick_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150417_aV, 1, 1));
        }
        if (ConfigBlocksItems.enableDoors) {
            for (int i4 = 0; i4 < ModBlocks.doors.length; ++i4) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.doors[i4], 3), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i4 + 1));
            }
            ModRecipes.removeFirstRecipeFor(Items.field_151135_aq);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151135_aq, 3), new Object[]{"xx", "xx", "xx", Character.valueOf('x'), "plankWood"}));
            ModRecipes.removeFirstRecipeFor(Items.field_151139_aw);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151139_aw, 3), new Object[]{"xx", "xx", "xx", Character.valueOf('x'), "ingotIron"}));
        }
        if (ConfigBlocksItems.enableTrapdoors) {
            for (int i5 = 0; i5 < ModBlocks.trapdoors.length; ++i5) {
                if (i5 == 5 && !ConfigBlocksItems.enableCrimsonBlocks || i5 == 6 && !ConfigBlocksItems.enableWarpedBlocks) continue;
                ItemStack planks = new ItemStack(Blocks.field_150344_f, 1, i5 + 1);
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.trapdoors[i5], 2), "xxx", "xxx", Character.valueOf('x'), planks);
            }
        }
        if (ConfigBlocksItems.enableSigns) {
            for (int i6 = 0; i6 < ModItems.signs.length; ++i6) {
                ItemStack planks = new ItemStack(Blocks.field_150344_f, 1, i6 + 1);
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.signs[i6], 3), "xxx", "xxx", " y ", Character.valueOf('x'), planks, Character.valueOf('y'), "stickWood");
            }
        }
        if (ConfigBlocksItems.enableRedSandstone) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone), "xx", "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150354_m, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone, 1, 1), "x", "x", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone_slab));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone, 4, 2), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_slab, 6, 1), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone, 1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_slab, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone, 1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.red_sandstone);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_sandstone_wall, 6, 0), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.red_sandstone, 1, 0));
        }
        if (ConfigBlocksItems.enableFences) {
            int i7;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150422_aJ, 3), new Object[]{"xyx", "xyx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150386_bk, 6), new Object[]{"xyx", "xyx", Character.valueOf('x'), Blocks.field_150385_bj, Character.valueOf('y'), "ingotBrickNether"}));
            for (i7 = 0; i7 < ModBlocks.fences.length; ++i7) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.fences[i7], 3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i7 + 1), Character.valueOf('y'), "stickWood");
            }
            for (i7 = 0; i7 < ModBlocks.gates.length; ++i7) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.gates[i7]), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i7 + 1), Character.valueOf('y'), "stickWood");
            }
        }
        if (ConfigBlocksItems.enableBanners) {
            for (EnumColour colour : EnumColour.values()) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.banner, 1, colour.getDamage()), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150325_L, 1, colour.getDamage()), Character.valueOf('y'), "stickWood");
            }
            GameRegistry.addRecipe((IRecipe)new RecipeDuplicatePattern());
            GameRegistry.addRecipe((IRecipe)new RecipeAddPattern());
        }
        if (ConfigBlocksItems.enableArmourStand) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.armour_stand), "xxx", " x ", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack((Block)Blocks.field_150333_U));
        }
        if (ConfigEntities.enableRabbit) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.rabbit_stew), " R ", "CPM", " B ", Character.valueOf('R'), new ItemStack(ModItems.cooked_rabbit), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('M'), Blocks.field_150338_P, Character.valueOf('B'), "bowlWood");
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.rabbit_stew), " R ", "CPD", " B ", Character.valueOf('R'), new ItemStack(ModItems.cooked_rabbit), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('D'), Blocks.field_150337_Q, Character.valueOf('B'), "bowlWood");
            GameRegistry.addSmelting((Item)ModItems.raw_rabbit, (ItemStack)new ItemStack(ModItems.cooked_rabbit), (float)0.35f);
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151116_aA), "xx", "xx", Character.valueOf('x'), ModItems.rabbit_hide);
        }
        if (ConfigTweaks.enableOldGravel) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.old_gravel, 4), "xy", "yx", Character.valueOf('x'), ModBlocks.coarse_dirt, Character.valueOf('y'), Blocks.field_150351_n);
        }
        if (ConfigBlocksItems.enableSponge) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.sponge), Blocks.field_150360_v);
            ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150360_v), ModBlocks.sponge);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.sponge, 1, 1), (ItemStack)new ItemStack(ModBlocks.sponge), (float)0.0f);
        }
        if (ConfigBlocksItems.enableBeetroot) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.beetroot_soup), "xxx", "xxx", " y ", Character.valueOf('x'), "cropBeetroot", Character.valueOf('y'), "bowlWood");
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 1), "cropBeetroot");
        }
        if (ConfigBlocksItems.enableChorusFruit) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_brick_slab, 6), "xxx", Character.valueOf('x'), ModBlocks.end_bricks);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_brick_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.end_bricks);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_brick_wall, 6, 0), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.end_bricks, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_block, 4), "xx", "xx", Character.valueOf('x'), ModItems.popped_chorus_fruit);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_stairs, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.purpur_block);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_slab, 6), "xxx", Character.valueOf('x'), ModBlocks.purpur_block);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.purpur_pillar), "x", "x", Character.valueOf('x'), ModBlocks.purpur_slab);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_bricks), "xx", "xx", Character.valueOf('x'), Blocks.field_150377_bs);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.chorus_fruit), (ItemStack)new ItemStack(ModItems.popped_chorus_fruit), (float)0.0f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.end_rod), "x", "y", Character.valueOf('x'), Items.field_151072_bj, Character.valueOf('y'), ModItems.popped_chorus_fruit);
        }
        if (ConfigBlocksItems.enableCryingObsidian) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.crying_obsidian), Blocks.field_150343_Z, "gemLapis");
        }
        if (ConfigBlocksItems.enableLingeringPotions) {
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.dragon_breath), new ItemStack((Item)Items.field_151068_bn, 1, 8195), ModItems.chorus_fruit, ModItems.chorus_fruit);
        }
        if (ConfigEntities.enableDragonRespawn) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.end_crystal), "xxx", "xyx", "xzx", Character.valueOf('x'), "blockGlassColorless", Character.valueOf('y'), Items.field_151061_bv, Character.valueOf('z'), Items.field_151073_bk);
        }
        if (ConfigTweaks.enableRoses) {
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 1), ModBlocks.rose);
            ModRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.rose));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.rose, 12), "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        }
        if (ConfigBlocksItems.enableTippedArrows && ConfigBlocksItems.enableLingeringPotions) {
            RecipeSorter.register((String)"etfuturum.RecipeTippedArrow", RecipeTippedArrow.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
            GameRegistry.addRecipe((IRecipe)new RecipeTippedArrow(new ItemStack(ModItems.tipped_arrow), "xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151032_g, Character.valueOf('y'), new ItemStack(ModItems.lingering_potion, 1, Short.MAX_VALUE)));
        }
        if (ConfigBlocksItems.enableMagmaBlock) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.magma_block), "xx", "xx", Character.valueOf('x'), new ItemStack(Items.field_151064_bs));
        }
        if (ConfigBlocksItems.enableNewNetherBricks) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.new_nether_brick, 1, 0), "xi", "ix", Character.valueOf('x'), Items.field_151075_bm, Character.valueOf('i'), "ingotBrickNether");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.new_nether_brick, 1, 2), "x", "x", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150333_U, 1, 6));
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150385_bj, 1, 1), (ItemStack)new ItemStack(ModBlocks.new_nether_brick), (float)0.1f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_nether_brick_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.new_nether_brick, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_nether_brick_slab, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.new_nether_brick, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.red_nether_brick_wall, 6, 0), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.new_nether_brick, 1, 0));
        }
        if (ConfigBlocksItems.enableNetherwartBlock) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.nether_wart_block), "xxx", "xxx", "xxx", Character.valueOf('x'), Items.field_151075_bm);
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151075_bm, 9), ModBlocks.nether_wart_block);
        }
        if (ConfigBlocksItems.enableBoneBlock) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.bone_block), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151100_aR, 1, 15));
        }
        for (i = 0; i < ore_dyes.length; ++i) {
            if (ConfigBlocksItems.enableConcrete) {
                int dye = ~i & 0xF;
                ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.concrete_powder, 8, i), ore_dyes[dye], new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n);
            }
            if (!ConfigBlocksItems.enableGlazedTerracotta) continue;
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150406_ce, 1, i), (ItemStack)new ItemStack(GameRegistry.findBlock((String)"etfuturum", (String)(dye_names[i] + "_glazed_terracotta"))), (float)0.1f);
        }
        if (ConfigFunctions.enableRecipeForTotem) {
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.totem), "EBE", "GBG", " G ", Character.valueOf('E'), "gemEmerald", Character.valueOf('G'), "ingotGold", Character.valueOf('B'), "blockGold");
        }
        if (ConfigBlocksItems.enableWoodRedstone) {
            for (i = 0; i < ModBlocks.buttons.length; ++i) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.buttons[i], 1), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i + 1));
            }
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150471_bO, 1), "x", Character.valueOf('x'), "plankWood");
            for (i = 0; i < ModBlocks.pressure_plates.length; ++i) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.pressure_plates[i], 1), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, i + 1));
            }
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150452_aw, 1), "xx", Character.valueOf('x'), "plankWood");
        }
        for (i = 0; i < 6; ++i) {
            Block bark;
            Block slog = i >= 4 ? ModBlocks.log2_stripped : ModBlocks.log_stripped;
            Block log = i >= 4 ? Blocks.field_150363_s : Blocks.field_150364_r;
            Block sbark = i >= 4 ? ModBlocks.wood2_stripped : ModBlocks.wood_stripped;
            Block block = bark = i >= 4 ? ModBlocks.log2_bark : ModBlocks.log_bark;
            if (ConfigBlocksItems.enableStrippedLogs) {
                ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, i), "x", Character.valueOf('x'), new ItemStack(slog, 1, i % 4));
                if (ConfigBlocksItems.enableBarkLogs) {
                    ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, i), "x", Character.valueOf('x'), new ItemStack(sbark, 1, i % 4));
                    ModRecipes.addShapedRecipe(new ItemStack(sbark, 3, i % 4), "xx", "xx", Character.valueOf('x'), new ItemStack(slog, 1, i % 4));
                }
            }
            if (!ConfigBlocksItems.enableBarkLogs) continue;
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, i), "x", Character.valueOf('x'), new ItemStack(bark, 1, i % 4));
            ModRecipes.addShapedRecipe(new ItemStack(bark, 3, i % 4), "xx", "xx", Character.valueOf('x'), new ItemStack(log, 1, i % 4));
        }
        if (ConfigBlocksItems.enableLantern) {
            if (!OreDictionary.getOres((String)"nuggetIron").isEmpty()) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.lantern), "xxx", "xix", "xxx", Character.valueOf('x'), "nuggetIron", Character.valueOf('i'), Blocks.field_150478_aa);
            } else {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.lantern), "i", "x", Character.valueOf('x'), "ingotIron", Character.valueOf('i'), Blocks.field_150478_aa);
            }
        }
        if (ConfigBlocksItems.enableBarrel) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.barrel), "xsx", "x x", "xsx", Character.valueOf('x'), "plankWood", Character.valueOf('s'), "slabWood");
        }
        if (ConfigBlocksItems.enableBlueIce) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.blue_ice), "xxx", "xxx", "xxx", Character.valueOf('x'), Blocks.field_150403_cj);
        }
        if (ConfigBlocksItems.enableSmoker) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smoker), " l ", "lxl", " l ", Character.valueOf('x'), Blocks.field_150460_al, Character.valueOf('l'), "logWood");
        }
        if (ConfigBlocksItems.enableBlastFurnace) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.blast_furnace), "iii", "ixi", "sss", Character.valueOf('x'), Blocks.field_150460_al, Character.valueOf('i'), "ingotIron", Character.valueOf('s'), ConfigBlocksItems.enableSmoothStone ? ModBlocks.smooth_stone : Blocks.field_150348_b);
        }
        if (ConfigBlocksItems.enableNetherite) {
            GameRegistry.addSmelting((Block)ModBlocks.ancient_debris, (ItemStack)new ItemStack(ModItems.netherite_scrap), (float)2.0f);
            if (ConfigBlocksItems.enableBlastFurnace) {
                BlastFurnaceRecipes.smelting().addRecipe(ModBlocks.ancient_debris, new ItemStack(ModItems.netherite_scrap), 2.0f);
            }
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.netherite_ingot), new ItemStack(ModItems.netherite_scrap), new ItemStack(ModItems.netherite_scrap), new ItemStack(ModItems.netherite_scrap), new ItemStack(ModItems.netherite_scrap), "ingotGold", "ingotGold", "ingotGold", "ingotGold");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.netherite_block), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.netherite_ingot);
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.netherite_ingot, 9), "x", Character.valueOf('x'), ModBlocks.netherite_block);
        }
        if (ConfigBlocksItems.enableNetherite) {
            Item[][] items = new Item[][]{{Items.field_151161_ac, Items.field_151163_ad, Items.field_151173_ae, Items.field_151175_af, Items.field_151046_w, Items.field_151056_x, Items.field_151012_L, Items.field_151047_v, Items.field_151048_u}, {ModItems.netherite_helmet, ModItems.netherite_chestplate, ModItems.netherite_leggings, ModItems.netherite_boots, ModItems.netherite_pickaxe, ModItems.netherite_axe, ModItems.netherite_hoe, ModItems.netherite_spade, ModItems.netherite_sword}};
            for (i2 = 0; i2 < items[0].length; ++i2) {
                ModRecipes.addShapelessRecipe(new ItemStack(items[1][i2]), "ingotNetherite", items[0][i2]);
            }
        }
        if (ConfigBlocksItems.enableNetherGold) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.nether_gold_ore), (ItemStack)new ItemStack(Items.field_151043_k), (float)0.1f);
        }
        if (ConfigBlocksItems.enableSmoothStone) {
            Item stoneTile;
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150348_b), (ItemStack)new ItemStack(ModBlocks.smooth_stone), (float)0.1f);
            if (Loader.isModLoaded((String)"bluepower") && (stoneTile = GameRegistry.findItem((String)"bluepower", (String)"stone_tile")) != null) {
                ModRecipes.addShapedRecipe(new ItemStack(stoneTile, 4), "xx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_stone));
            }
        }
        if (ConfigBlocksItems.enableSmoothSandstone) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150322_A, 1, 0), (ItemStack)new ItemStack(ModBlocks.smooth_sandstone), (float)0.1f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smooth_sandstone_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_sandstone, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smooth_sandstone_slab, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_sandstone, 1, 0));
            if (ConfigBlocksItems.enableRedSandstone) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.red_sandstone, 1, 0), (ItemStack)new ItemStack(ModBlocks.smooth_red_sandstone), (float)0.1f);
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smooth_red_sandstone_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_red_sandstone, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smooth_red_sandstone_slab, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_red_sandstone, 1, 0));
            }
        }
        if (ConfigBlocksItems.enableSmoothQuartz) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150371_ca, 1, 0), (ItemStack)new ItemStack(ModBlocks.smooth_quartz), (float)0.1f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smooth_quartz_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.smooth_quartz, 1, 0));
        }
        if (ConfigBlocksItems.enableQuartzBricks) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.quartz_bricks), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150371_ca, 1, 0));
        }
        if (ConfigBlocksItems.enableNewDyes) {
            if (ConfigBlocksItems.enableLilyOfTheValley) {
                ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 0), new ItemStack(ModBlocks.lily_of_the_valley, 1, 0));
            }
            if (ConfigBlocksItems.enableCornflower) {
                ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 1), new ItemStack(ModBlocks.cornflower, 1, 0));
            }
            if (ConfigBlocksItems.enableWitherRose) {
                ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 3), new ItemStack(ModBlocks.wither_rose, 1, 0));
            }
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 0), new ItemStack(Items.field_151100_aR, 1, 15));
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 1), new ItemStack(Items.field_151100_aR, 1, 4));
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 2), new ItemStack(Items.field_151100_aR, 1, 3));
            ModRecipes.addShapelessRecipe(new ItemStack(ModItems.new_dye, 1, 3), new ItemStack(Items.field_151100_aR, 1, 0));
        }
        if (ConfigBlocksItems.enableCopper) {
            Block[] stairs = new Block[]{ModBlocks.cut_copper_stairs, ModBlocks.exposed_cut_copper_stairs, ModBlocks.weathered_cut_copper_stairs, ModBlocks.oxidized_cut_copper_stairs, ModBlocks.waxed_cut_copper_stairs, ModBlocks.waxed_exposed_cut_copper_stairs, ModBlocks.waxed_weathered_cut_copper_stairs, ModBlocks.waxed_oxidized_cut_copper_stairs};
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.copper_block, 1), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModItems.copper_ingot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.copper_ingot, 9), "x", Character.valueOf('x'), new ItemStack(ModBlocks.copper_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.copper_ingot, 9), "x", Character.valueOf('x'), new ItemStack(ModBlocks.copper_block, 1, 8));
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.copper_ore), (ItemStack)new ItemStack(ModItems.copper_ingot), (float)0.7f);
            for (i2 = 0; i2 <= 7; ++i2) {
                int j = i2;
                if (i2 > 3) {
                    j = i2 + 4;
                }
                if (j != 11) {
                    ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.copper_block, 4, j + 4), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.copper_block, 1, j));
                }
                if (i2 != 7) {
                    ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.cut_copper_slab, 6, i2), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.copper_block, 1, j + 4));
                    ModRecipes.addShapedRecipe(new ItemStack(stairs[i2], 4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.copper_block, 1, j + 4));
                }
                if (OreDictionary.doesOreNameExist((String)"materialWax") || OreDictionary.doesOreNameExist((String)"materialWaxcomb") || OreDictionary.doesOreNameExist((String)"materialHoneycomb") || OreDictionary.doesOreNameExist((String)"itemBeeswax")) {
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.copper_block, 1, i2 + 8), "itemBeeswax", new ItemStack(ModBlocks.copper_block, 1, i2));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.copper_block, 1, i2 + 8), "materialWax", new ItemStack(ModBlocks.copper_block, 1, i2));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.copper_block, 1, i2 + 8), "materialWaxcomb", new ItemStack(ModBlocks.copper_block, 1, i2));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.copper_block, 1, i2 + 8), "materialHoneycomb", new ItemStack(ModBlocks.copper_block, 1, i2));
                    if (i2 <= 3) continue;
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.cut_copper_slab, 1, i2), "itemBeeswax", new ItemStack(ModBlocks.cut_copper_slab, 1, i2 - 4));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.cut_copper_slab, 1, i2), "materialWax", new ItemStack(ModBlocks.cut_copper_slab, 1, i2 - 4));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.cut_copper_slab, 1, i2), "materialWaxcomb", new ItemStack(ModBlocks.cut_copper_slab, 1, i2 - 4));
                    ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.cut_copper_slab, 1, i2), "materialHoneycomb", new ItemStack(ModBlocks.cut_copper_slab, 1, i2 - 4));
                    ModRecipes.addShapelessRecipe(new ItemStack(stairs[i2], 1), "itemBeeswax", new ItemStack(stairs[i2 - 4], 1));
                    ModRecipes.addShapelessRecipe(new ItemStack(stairs[i2], 1), "materialWax", new ItemStack(stairs[i2 - 4], 1));
                    ModRecipes.addShapelessRecipe(new ItemStack(stairs[i2], 1), "materialWaxcomb", new ItemStack(stairs[i2 - 4], 1));
                    ModRecipes.addShapelessRecipe(new ItemStack(stairs[i2], 1), "materialHoneycomb", new ItemStack(stairs[i2 - 4], 1));
                    continue;
                }
                ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.copper_block, 1, i2 + 8), "slimeball", new ItemStack(ModBlocks.copper_block, 1, i2));
                if (i2 <= 3) continue;
                ModRecipes.addShapelessRecipe(new ItemStack(ModBlocks.cut_copper_slab, 1, i2), "slimeball", new ItemStack(stairs[i2], 1, i2 - 4));
                ModRecipes.addShapelessRecipe(new ItemStack(stairs[i2], 1), "slimeball", new ItemStack(stairs[i2 - 4], 1));
            }
        }
        if (ConfigBlocksItems.enableDeepslate) {
            GameRegistry.addSmelting((Block)ModBlocks.cobbled_deepslate, (ItemStack)new ItemStack(ModBlocks.deepslate), (float)0.1f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.deepslate_bricks, 1, 0), (ItemStack)new ItemStack(ModBlocks.deepslate_bricks, 1, 1), (float)0.1f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.deepslate_bricks, 1, 2), (ItemStack)new ItemStack(ModBlocks.deepslate_bricks, 1, 3), (float)0.1f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.polished_deepslate, 4, 0), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.cobbled_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_bricks, 4, 0), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.polished_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_bricks, 4, 2), "xx", "xx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_bricks, 1, 4), "x", "x", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_slab, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.cobbled_deepslate_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.cobbled_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.polished_deepslate_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.polished_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_brick_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_tile_stairs, 4, 0), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_slab, 6, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.cobbled_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_slab, 6, 1), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.polished_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_brick_slab, 4, 0), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_brick_slab, 4, 1), "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_wall, 6, 0), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.cobbled_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_wall, 6, 1), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.polished_deepslate, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_brick_wall, 6, 0), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.deepslate_brick_wall, 6, 1), "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModBlocks.deepslate_bricks, 1, 2));
        }
        if (ConfigBlocksItems.enableRawOres) {
            if (ConfigBlocksItems.enableCopper) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.raw_ore_block, 1, 0), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModItems.raw_ore, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.raw_ore, 9, 0), "x", Character.valueOf('x'), new ItemStack(ModBlocks.raw_ore_block, 1, 0));
                GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.raw_ore, 1, 0), (ItemStack)new ItemStack(ModItems.copper_ingot, 1, 0), (float)0.7f);
            }
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.raw_ore_block, 1, 1), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModItems.raw_ore, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.raw_ore, 9, 1), "x", Character.valueOf('x'), new ItemStack(ModBlocks.raw_ore_block, 1, 1));
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.raw_ore, 1, 1), (ItemStack)new ItemStack(Items.field_151042_j, 1, 0), (float)0.7f);
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.raw_ore_block, 1, 2), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ModItems.raw_ore, 1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(ModItems.raw_ore, 9, 2), "x", Character.valueOf('x'), new ItemStack(ModBlocks.raw_ore_block, 1, 2));
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.raw_ore, 1, 2), (ItemStack)new ItemStack(Items.field_151043_k, 1, 0), (float)0.7f);
        }
        if (ConfigBlocksItems.enableSuspiciousStew) {
            for (int i8 = 0; i8 < ModRecipes.getStewFlowers().size(); ++i8) {
                ItemStack stew = new ItemStack(ModItems.suspicious_stew, 1, 0);
                PotionEffect effect = EtFuturum.getSuspiciousStewEffect(ModRecipes.getStewFlowers().get(i8));
                stew.field_77990_d = new NBTTagCompound();
                NBTTagList effectsList = new NBTTagList();
                stew.field_77990_d.func_74782_a("Effects", (NBTBase)effectsList);
                NBTTagCompound potionEffect = new NBTTagCompound();
                potionEffect.func_74774_a("EffectId", (byte)effect.func_76456_a());
                potionEffect.func_74768_a("EffectDuration", effect.func_76459_b());
                effectsList.func_74742_a((NBTBase)potionEffect);
                ModRecipes.addShapelessRecipe(stew, Blocks.field_150337_Q, Blocks.field_150338_P, Items.field_151054_z, ModRecipes.getStewFlowers().get(i8));
            }
        }
        if (ConfigBlocksItems.enableNewBoats) {
            int i9;
            for (i9 = EntityNewBoat.Type.values().length - 1; i9 >= 0; --i9) {
                ModRecipes.addShapedRecipe(new ItemStack(i9 == 0 && ConfigBlocksItems.replaceOldBoats ? Items.field_151124_az : ModItems.boats[i9], 1), ConfigBlocksItems.replaceOldBoats ? "x x" : "xyx", "xxx", Character.valueOf('x'), i9 == 0 ? "plankWood" : new ItemStack(Blocks.field_150344_f, 1, i9), Character.valueOf('y'), new ItemStack(Items.field_151038_n, 1));
            }
            if (!ConfigBlocksItems.replaceOldBoats) {
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151124_az), ModItems.boats[0]);
                ModRecipes.addShapelessRecipe(new ItemStack(ModItems.boats[0]), Items.field_151038_n, Items.field_151124_az);
            }
            for (i9 = EntityNewBoat.Type.values().length - 1; i9 >= 0; --i9) {
                ModRecipes.addShapedRecipe(new ItemStack(ModItems.chest_boats[i9]), "c", "b", Character.valueOf('b'), i9 == 0 && ConfigBlocksItems.replaceOldBoats ? Items.field_151124_az : ModItems.boats[i9], Character.valueOf('c'), Blocks.field_150486_ae);
            }
        }
        if (ConfigBlocksItems.enableShulkerBoxes) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.shulker_box), "x", "c", "x", Character.valueOf('x'), new ItemStack(ModItems.shulker_shell), Character.valueOf('c'), new ItemStack((Block)Blocks.field_150486_ae));
            for (int i10 = 0; i10 < 16; ++i10) {
                ItemStack output = new ItemStack(ModBlocks.shulker_box);
                output.func_77982_d(new NBTTagCompound());
                output.func_77978_p().func_74774_a("Color", (byte)(i10 + 1));
                GameRegistry.addRecipe((IRecipe)new RecipeDyedShulkerBox(output, new Object[]{ModBlocks.shulker_box, ore_dyes[(byte)(~i10 & 0xF)]}));
            }
        }
        if (ConfigWorld.tileReplacementMode == -1 && ConfigBlocksItems.enableNewTileEntities) {
            if (ConfigBlocksItems.enableAnvil) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(ModBlocks.anvil), (Object[])new Object[]{"BBB", " I ", "III", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('B'), new ItemStack(Blocks.field_150339_S)});
                ModRecipes.removeFirstRecipeFor(Blocks.field_150467_bQ);
            }
            if (ConfigBlocksItems.enableBrewingStands) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(ModBlocks.brewing_stand), (Object[])new Object[]{" B ", "CCC", Character.valueOf('C'), new ItemStack(Blocks.field_150347_e), Character.valueOf('B'), new ItemStack(Items.field_151072_bj)});
                ModRecipes.removeFirstRecipeFor(Blocks.field_150382_bo);
            }
            if (ConfigBlocksItems.enableColourfulBeacons) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(ModBlocks.beacon), (Object[])new Object[]{"GGG", "GNG", "OOO", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('N'), new ItemStack(Items.field_151156_bN), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z)});
                ModRecipes.removeFirstRecipeFor((Block)Blocks.field_150461_bJ);
            }
            if (ConfigBlocksItems.enableEnchantingTable) {
                ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.enchanting_table), " B ", "D#D", "###", Character.valueOf('#'), Blocks.field_150343_Z, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('D'), "gemDiamond");
                ModRecipes.removeFirstRecipeFor(Blocks.field_150381_bn);
            }
        }
        if (ConfigBlocksItems.enableExtraVanillaWalls) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.generic_wall, 6, 0), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150417_aV, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.generic_wall, 6, 1), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150417_aV, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.generic_wall, 6, 2), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150322_A, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.generic_wall, 6, 3), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150336_V, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.nether_brick_wall, 6), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150385_bj));
        }
        if (ConfigBlocksItems.enableSmithingTable) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.smithing_table, 1, 0), "II", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('I'), "ingotIron");
        }
        if (ConfigBlocksItems.enableFletchingTable) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.fletching_table, 1, 0), "FF", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1, 0));
        }
        if (ConfigBlocksItems.enableStonecutter) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.stonecutter, 1, 0), " I ", "SSS", Character.valueOf('S'), "stone", Character.valueOf('I'), "ingotIron");
        }
        if (ConfigBlocksItems.enableComposter) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.composter, 1, 0), "S S", "S S", "SSS", Character.valueOf('S'), "slabWood");
        }
        if (ConfigBlocksItems.enableCartographyTable) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.cartography_table, 1, 0), "pp", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('p'), new ItemStack(Items.field_151121_aF, 1, 0));
        }
        if (ConfigBlocksItems.enableLoom) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.loom, 1, 0), "SS", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1, 0));
        }
        if (ConfigBlocksItems.enableAmethyst) {
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.amethyst_block, 1, 0), "AA", "AA", Character.valueOf('A'), "gemAmethyst");
            ModRecipes.addShapedRecipe(new ItemStack(ModBlocks.tinted_glass, 2, 0), " A ", "AGA", " A ", Character.valueOf('A'), "gemAmethyst", Character.valueOf('G'), "blockGlassColorless");
        }
    }

    private static List<ItemStack> getStewFlowers() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 2));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 3));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 1));
        list.add(new ItemStack((Block)Blocks.field_150327_N, 1));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 8));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 0));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 4));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 5));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 6));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 7));
        if (ConfigBlocksItems.enableLilyOfTheValley) {
            list.add(new ItemStack(ModBlocks.lily_of_the_valley, 1, 0));
        }
        if (ConfigBlocksItems.enableCornflower) {
            list.add(new ItemStack(ModBlocks.cornflower, 1, 0));
        }
        if (ConfigBlocksItems.enableWitherRose) {
            list.add(new ItemStack(ModBlocks.wither_rose, 1, 0));
        }
        return list;
    }

    private static void addShapedRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapedEtFuturumRecipe(output, objects));
    }

    private static void addShapelessRecipe(ItemStack output, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapelessEtFuturumRecipe(output, objects));
    }

    private static void removeFirstRecipeFor(Block block) {
        ModRecipes.removeFirstRecipeFor(Item.func_150898_a((Block)block));
    }

    private static void removeFirstRecipeFor(Block block, int meta) {
        ModRecipes.removeFirstRecipeFor(Item.func_150898_a((Block)block), meta);
    }

    private static void removeFirstRecipeFor(Item item) {
        ModRecipes.removeFirstRecipeFor(item, -1);
    }

    private static void removeFirstRecipeFor(Item item, int meta) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack stack;
            if (recipe == null || (stack = ((IRecipe)recipe).func_77571_b()) == null || stack.func_77973_b() != item || meta != -1 && meta != stack.func_77960_j()) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
            return;
        }
    }
}

