/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class SmokerRecipes {
    private static final SmokerRecipes smeltingBase = new SmokerRecipes();
    public Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    public Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static SmokerRecipes smelting() {
        return smeltingBase;
    }

    private SmokerRecipes() {
    }

    public static void init() {
        if (ConfigFunctions.enableAutoAddSmoker) {
            for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack result = (ItemStack)entry.getValue();
                if (input == null || result == null || !(input.func_77973_b() instanceof ItemFood) && !(result.func_77973_b() instanceof ItemFood)) continue;
                smeltingBase.addRecipe(input, result, result.func_77973_b().getSmeltingExperience(result));
            }
        } else {
            smeltingBase.addRecipe(Items.field_151147_al, new ItemStack(Items.field_151157_am), 0.35f);
            smeltingBase.addRecipe(Items.field_151082_bd, new ItemStack(Items.field_151083_be), 0.35f);
            smeltingBase.addRecipe(Items.field_151076_bf, new ItemStack(Items.field_151077_bg), 0.35f);
            smeltingBase.addRecipe(Items.field_151174_bG, new ItemStack(Items.field_151168_bH), 0.35f);
            smeltingBase.addRecipe(ModItems.raw_mutton, new ItemStack(ModItems.cooked_mutton), 0.35f);
            for (ItemFishFood.FishType fishtype : ItemFishFood.FishType.values()) {
                if (!fishtype.func_150973_i()) continue;
                smeltingBase.addRecipe(new ItemStack(Items.field_151115_aP, 1, fishtype.func_150976_a()), new ItemStack(Items.field_151101_aQ, 1, fishtype.func_150976_a()), 0.35f);
            }
        }
    }

    public void addRecipe(Block p_151393_1_, ItemStack p_151393_2_, float p_151393_3_) {
        this.addRecipe(Item.func_150898_a((Block)p_151393_1_), p_151393_2_, p_151393_3_);
    }

    public void addRecipe(Item p_151396_1_, ItemStack p_151396_2_, float p_151396_3_) {
        this.addRecipe(new ItemStack(p_151396_1_, 1, Short.MAX_VALUE), p_151396_2_, p_151396_3_);
    }

    public void addRecipe(ItemStack p_151394_1_, ItemStack p_151394_2_, float p_151394_3_) {
        this.smeltingList.put(p_151394_1_, p_151394_2_);
        this.experienceList.put(p_151394_2_, Float.valueOf(p_151394_3_));
    }

    public ItemStack getSmeltingResult(ItemStack p_151395_1_) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.func_151397_a(p_151395_1_, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private boolean func_151397_a(ItemStack p_151397_1_, ItemStack p_151397_2_) {
        return p_151397_2_.func_77973_b() == p_151397_1_.func_77973_b() && (p_151397_2_.func_77960_j() == Short.MAX_VALUE || p_151397_2_.func_77960_j() == p_151397_1_.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float func_151398_b(ItemStack p_151398_1_) {
        Map.Entry<ItemStack, Float> entry;
        float ret = p_151398_1_.func_77973_b().getSmeltingExperience(p_151398_1_);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.func_151397_a(p_151398_1_, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }
}

