/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.spectator;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class SpectatorModeClient {
    public static final SpectatorModeClient INSTANCE = new SpectatorModeClient();
    private static boolean hadHeldItemTooltips;

    @SideOnly(value=Side.CLIENT)
    private static void setBipedVisible(ModelBiped biped, boolean visible) {
        biped.field_78116_c.field_78806_j = visible;
        biped.field_78114_d.field_78806_j = visible;
        biped.field_78115_e.field_78806_j = visible;
        biped.field_78112_f.field_78806_j = visible;
        biped.field_78113_g.field_78806_j = visible;
        biped.field_78123_h.field_78806_j = visible;
        biped.field_78124_i.field_78806_j = visible;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            SpectatorModeClient.setBipedVisible(event.renderer.field_77109_a, false);
            event.renderer.field_77109_a.field_78116_c.field_78806_j = true;
            event.renderer.field_77109_a.field_78114_d.field_78806_j = true;
        } else {
            SpectatorModeClient.setBipedVisible(event.renderer.field_77109_a, true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayerArmor(RenderPlayerEvent.Specials.Pre event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onOverlayRenderPre(RenderGameOverlayEvent.Pre event) {
        if (SpectatorMode.isSpectator((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR || event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
                event.setCanceled(true);
            }
            if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
                hadHeldItemTooltips = Minecraft.func_71410_x().field_71474_y.field_92117_D;
                Minecraft.func_71410_x().field_71474_y.field_92117_D = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onOverlayRenderPost(RenderGameOverlayEvent.Post event) {
        if (SpectatorMode.isSpectator((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft.func_71410_x().field_71474_y.field_92117_D = hadHeldItemTooltips;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onHandRender(RenderHandEvent event) {
        if (SpectatorMode.isSpectator((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFireRender(RenderBlockOverlayEvent event) {
        if (SpectatorMode.isSpectator((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.entity instanceof EntityPlayer && SpectatorMode.isSpectator((EntityPlayer)event.entity) && (event.block.func_149688_o() == Material.field_151586_h || event.block.func_149688_o() == Material.field_151587_i)) {
            event.setCanceled(true);
            event.density = 0.0f;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        int meta;
        Block block;
        if (!(!SpectatorMode.isSpectator(event.player) || (block = Minecraft.func_71410_x().field_71441_e.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d)).hasTileEntity(meta = Minecraft.func_71410_x().field_71441_e.func_72805_g(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d)) && Minecraft.func_71410_x().field_71441_e.func_147438_o(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) instanceof IInventory)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null && event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71442_b.field_78779_k == SpectatorMode.SPECTATOR_GAMETYPE && !player.field_71075_bZ.field_75100_b) {
            player.field_71075_bZ.field_75100_b = true;
            player.func_71016_p();
        }
    }
}

