/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.ExternalContent;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAmethystGeode
extends WorldGenerator {
    private final int outerMeta = ConfigWorld.amethystOuterBlock == ExternalContent.netherlicious_basalt_bricks ? 6 : 0;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        float size = (float)(random.nextInt(3) + 6) + random.nextFloat();
        float DISTANCE_BASALT_SQ = size * size;
        float DISTANCE_CALCITE_SQ = (size - 1.0f) * (size - 1.0f);
        float DISTANCE_AMETHYST_SQ = (size - 2.0f) * (size - 2.0f);
        float DISTANCE_INNER_SQ = (size - 3.0f) * (size - 3.0f);
        int sizeInt = MathHelper.func_76141_d((float)size);
        if (!this.canGeodeGenerateHere(world, x, y, z, sizeInt)) {
            return false;
        }
        int holeX = -1;
        int holeY = -1;
        int holeZ = -1;
        float radius = -1.0f;
        int holeSize = random.nextFloat() < 0.95f ? random.nextInt(3) + 5 : -1;
        float holeTheta = 0.0f;
        float holePhi = 0.0f;
        if (holeSize != -1) {
            holeTheta = (float)(Math.acos(1.0f - 2.0f * random.nextFloat()) - 1.5707963267948966);
            holePhi = (float)((double)random.nextFloat() * Math.PI * 2.0);
            radius = size - (random.nextFloat() * 2.0f + 0.5f) + random.nextFloat() * 0.0f;
            holeX = Math.round(radius * MathHelper.func_76134_b((float)holePhi) * MathHelper.func_76134_b((float)holeTheta));
            holeY = Math.round(radius * MathHelper.func_76126_a((float)holeTheta));
            holeZ = Math.round(radius * MathHelper.func_76126_a((float)holePhi) * MathHelper.func_76134_b((float)holeTheta));
        }
        for (int i = -sizeInt; i <= sizeInt; ++i) {
            for (int j = -sizeInt; j <= sizeInt; ++j) {
                for (int k = -sizeInt; k <= sizeInt; ++k) {
                    double deltaZ;
                    double deltaY;
                    double deltaX;
                    int distSq = i * i + j * j + k * k;
                    Block block = world.func_147439_a(x + i, y + j, z + k);
                    if (block.func_149712_f(world, x + i, y + j, z + k) == -1.0f) continue;
                    if (holeSize > -1 && (deltaX = (double)Math.abs(i - holeX)) + (deltaY = (double)Math.abs(j - holeY)) + (deltaZ = (double)Math.abs(k - holeZ)) < (double)holeSize && (float)distSq <= DISTANCE_BASALT_SQ) {
                        world.func_147468_f(x + i, y + j, z + k);
                        continue;
                    }
                    if ((float)distSq <= DISTANCE_INNER_SQ) {
                        world.func_147468_f(x + i, y + j, z + k);
                        continue;
                    }
                    if ((float)distSq <= DISTANCE_BASALT_SQ && (float)distSq > DISTANCE_CALCITE_SQ) {
                        world.func_147465_d(x + i, y + j, z + k, ConfigWorld.amethystOuterBlock, this.outerMeta, 2);
                        continue;
                    }
                    if ((float)distSq <= DISTANCE_CALCITE_SQ && (float)distSq > DISTANCE_AMETHYST_SQ) {
                        world.func_147465_d(x + i, y + j, z + k, ModBlocks.calcite, 0, 2);
                        continue;
                    }
                    if (!((float)distSq <= DISTANCE_AMETHYST_SQ)) continue;
                    this.placeAmethyst(world, random, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private boolean canGeodeGenerateHere(World world, int x, int y, int z, int size) {
        int air = 0;
        int cornerDist = (int)(((float)size - 0.5f) / MathHelper.func_76129_c((float)3.0f));
        if (this.isInvalidCorner(world, x + cornerDist, y + size, z + cornerDist)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x + cornerDist, y + size, z - cornerDist)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x - cornerDist, y + size, z + cornerDist)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x - cornerDist, y + size, z - cornerDist) && air++ >= 4) {
            return false;
        }
        if (this.isInvalidCorner(world, x + cornerDist, y - cornerDist, z + cornerDist) && air++ >= 4) {
            return false;
        }
        if (this.isInvalidCorner(world, x + cornerDist, y - cornerDist, z - cornerDist) && air++ >= 4) {
            return false;
        }
        if (this.isInvalidCorner(world, x - cornerDist, y - cornerDist, z + cornerDist) && air++ >= 4) {
            return false;
        }
        if (this.isInvalidCorner(world, x - cornerDist, y - cornerDist, z - cornerDist) && air++ >= 4) {
            return false;
        }
        return air < 4;
    }

    private boolean isInvalidCorner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return world.func_72937_j(x, y, z) && block.isAir((IBlockAccess)world, x, y, z) && !block.func_149662_c();
    }

    private void placeAmethyst(World world, Random random, int x, int y, int z) {
        if (random.nextInt(12) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.budding_amethyst);
            for (EnumFacing facing : EnumFacing.values()) {
                int offZ;
                int offY;
                int offX;
                int clusterSize = random.nextInt(5);
                if (clusterSize <= 0 || world.func_147439_a(offX = x + facing.func_82601_c(), offY = y + facing.func_96559_d(), offZ = z + facing.func_82599_e()).func_149688_o() != Material.field_151579_a && world.func_147439_a(offX, offY, offZ).func_149688_o() != Material.field_151586_h) continue;
                Block block = clusterSize > 2 ? ModBlocks.amethyst_cluster_2 : ModBlocks.amethyst_cluster_1;
                int meta = (clusterSize == 1 || clusterSize == 3 ? 0 : 6) + facing.ordinal();
                world.func_147465_d(offX, offY, offZ, block, meta, 2);
            }
        } else {
            world.func_147449_b(x, y, z, ModBlocks.amethyst_block);
        }
    }
}

