/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityWashingMachine
extends TileEntity
implements ISidedInventory {
    private ItemStack[] inventory = new ItemStack[5];
    private boolean washing = false;
    public boolean superMode = false;
    public int progress = 0;
    public int timeRemaining = 0;
    private Random rand = new Random();
    private int timer = 0;

    public void startWashing() {
        if (this.canWash()) {
            if (this.timeRemaining == 0) {
                this.superMode = this.inventory[4].func_77973_b() == MrCrayfishFurnitureMod.itemSuperSoapyWater;
                this.inventory[4] = new ItemStack(this.inventory[4].func_77973_b().func_77668_q());
                this.timeRemaining = 5000;
            }
            this.washing = true;
        }
    }

    public void stopWashing() {
        this.progress = 0;
        this.washing = false;
    }

    public boolean canWash() {
        if (this.inventory[4] == null && this.timeRemaining == 0) {
            return false;
        }
        if (this.inventory[4] != null && this.timeRemaining == 0 && this.inventory[4].func_77973_b() != MrCrayfishFurnitureMod.itemSoapyWater && this.inventory[4].func_77973_b() != MrCrayfishFurnitureMod.itemSuperSoapyWater) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < 4; ++i) {
            if (this.inventory[i] == null) continue;
            RecipeData data = RecipeAPI.getWashingMachineRecipeFromInput(this.inventory[i]);
            if (data == null) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public boolean isWashing() {
        return this.washing;
    }

    public void func_145845_h() {
        if (this.washing) {
            if (this.canRepair()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.inventory[i] == null || this.inventory[i].func_77958_k() - this.inventory[i].func_77960_j() == this.inventory[i].func_77958_k()) continue;
                    this.inventory[i].func_77964_b(this.inventory[i].func_77960_j() - 1);
                }
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory[4] != null) {
                    if (this.inventory[4].func_77973_b() == MrCrayfishFurnitureMod.itemSoapyWater) {
                        this.superMode = false;
                        this.inventory[4] = new ItemStack(MrCrayfishFurnitureMod.itemSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    } else if (this.inventory[4].func_77973_b() == MrCrayfishFurnitureMod.itemSuperSoapyWater) {
                        this.superMode = true;
                        this.inventory[4] = new ItemStack(MrCrayfishFurnitureMod.itemSuperSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.progress = 0;
                    this.washing = false;
                }
            }
            ++this.progress;
            if (this.progress >= 10000) {
                this.progress = 0;
            }
            if (this.timer == 20) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "cfm:washing_machine", 0.75f, 1.0f);
            }
            ++this.timer;
        }
    }

    public boolean canRepair() {
        return this.progress % (this.superMode ? 20 : 50) == 0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int number) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= number) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(number);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory[slot];
    }

    public void func_70299_a(int slot, ItemStack par2ItemStack) {
        this.inventory[slot] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Dishwasher";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)tagCompound.func_74781_a("Items");
            this.inventory = new ItemStack[6];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                byte slot = nbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        this.washing = tagCompound.func_74767_n("Washing");
        this.superMode = tagCompound.func_74767_n("SuperMode");
        this.progress = tagCompound.func_74762_e("Progress");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74757_a("Washing", this.washing);
        tagCompound.func_74757_a("SuperMode", this.superMode);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tagCom = pkt.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCom);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return null;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }
}

