/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.distributions.DistributionBase;
import neresources.api.messages.RegistryMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.Priority;
import neresources.api.utils.restrictions.Restriction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class RegisterOreMessage
extends RegistryMessage {
    private ItemStack ore;
    private ItemStack[] drops;
    private boolean needSilkTouch;
    private DistributionBase distribution;
    private int colour;
    private Restriction restriction;

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, ItemStack ... drops) {
        this(ore, distribution, -16777216, Restriction.OVERWORLD_LIKE, false, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, boolean needSilkTouch, ItemStack ... drops) {
        this(ore, distribution, -16777216, Restriction.OVERWORLD_LIKE, needSilkTouch, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, int colour, ItemStack ... drops) {
        this(ore, distribution, colour, Restriction.OVERWORLD_LIKE, false, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, int colour, Restriction restriction, boolean needSilkTouch, ItemStack ... drops) {
        this(ore, distribution, colour, restriction, needSilkTouch, Priority.FIRST, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, int colour, boolean needSilkTouch, Priority priority, ItemStack ... drops) {
        this(ore, distribution, colour, Restriction.OVERWORLD_LIKE, needSilkTouch, priority, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, Restriction restriction, ItemStack ... drops) {
        this(ore, distribution, -16777216, restriction, false, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, Restriction restriction, boolean needSilkTouch, ItemStack ... drops) {
        this(ore, distribution, -16777216, restriction, needSilkTouch, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, Restriction restriction, int colour, ItemStack ... drops) {
        this(ore, distribution, colour, restriction, false, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, Restriction restriction, int colour, boolean needSilkTouch, Priority priority, ItemStack ... drops) {
        this(ore, distribution, colour, restriction, needSilkTouch, priority, drops);
    }

    public RegisterOreMessage(ItemStack ore, DistributionBase distribution, int colour, Restriction restriction, boolean needSilkTouch, Priority priority, ItemStack ... drops) {
        super(priority, true);
        this.ore = ore;
        this.drops = drops;
        this.needSilkTouch = needSilkTouch;
        this.distribution = distribution;
        this.colour = colour;
        this.restriction = restriction;
    }

    public RegisterOreMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.ore = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("stack"));
        this.drops = MessageHelper.getItemStacks(tagCompound, "addDrops");
        this.needSilkTouch = tagCompound.func_74767_n("silkTouch");
        this.distribution = MessageHelper.getDistribution(tagCompound);
        this.colour = tagCompound.func_74764_b("colour") ? tagCompound.func_74762_e("colour") : -16777216;
        this.restriction = new Restriction(tagCompound.func_74775_l("restriction"));
    }

    public ItemStack getOre() {
        return this.ore;
    }

    public DistributionBase getDistribution() {
        return this.distribution;
    }

    public boolean needSilkTouch() {
        return this.needSilkTouch;
    }

    public int getColour() {
        return this.colour;
    }

    public ItemStack[] getDrops() {
        return this.drops;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("stack", (NBTBase)this.ore.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74782_a("addDrops", (NBTBase)MessageHelper.getItemStackList(this.drops));
        this.distribution.writeToNBT(tagCompound);
        tagCompound.func_74757_a("silkTouch", this.needSilkTouch);
        tagCompound.func_74768_a("colour", this.colour);
        tagCompound.func_74782_a("restriction", (NBTBase)this.restriction.writeToNBT());
        return tagCompound;
    }

    @Override
    public boolean isValid() {
        return this.ore != null && this.distribution.getDistribution().length == 256;
    }
}

