/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.PCCreativeTab;
import powercrystals.powerconverters.position.INeighboorUpdateTile;
import powercrystals.powerconverters.power.base.TileEntityBridgeComponent;

public class BlockPowerConverterCommon
extends BlockContainer {
    private IIcon _iconBridge;
    private IIcon _iconChargerOn;
    private IIcon _iconChargerOff;

    public BlockPowerConverterCommon() {
        super(Material.field_151571_B);
        this.func_149711_c(1.0f);
        this.func_149663_c("powerconverters.common");
        this.func_149647_a(PCCreativeTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        String folderName = this.func_149739_a().substring("tile.powerconverters.".length());
        this._iconBridge = ir.func_94245_a(String.format("%s:%s/bridge", "PowerConverters", folderName));
        this._iconChargerOff = ir.func_94245_a(String.format("%s:%s/charger_off", "PowerConverters", folderName));
        this._iconChargerOn = ir.func_94245_a(String.format("%s:%s/charger_on", "PowerConverters", folderName));
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return this._iconBridge;
        }
        if (meta == 2) {
            return this._iconChargerOff;
        }
        return null;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBridgeComponent) {
            if (meta == 0) {
                return this._iconBridge;
            }
            if (meta == 2) {
                boolean isConnected = ((TileEntityBridgeComponent)te).isSideConnectedClient(side);
                if (isConnected) {
                    return this._iconChargerOn;
                }
                return this._iconChargerOff;
            }
        }
        return this.func_149691_a(side, meta);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof INeighboorUpdateTile) {
            ((INeighboorUpdateTile)te).onNeighboorChanged();
        }
    }

    public TileEntity func_149915_a(World world, int md) {
        if (md == 0) {
            return new TileEntityEnergyBridge();
        }
        if (md == 2) {
            return new TileEntityCharger();
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityBridgeComponent) {
            TileEntityEnergyBridge bridge = ((TileEntityBridgeComponent)te).getFirstBridge();
            if (bridge != null) {
                player.openGui((Object)PowerConverterCore.instance, 0, world, bridge.field_145851_c, bridge.field_145848_d, bridge.field_145849_e);
            }
        } else if (te != null && te instanceof TileEntityEnergyBridge) {
            player.openGui((Object)PowerConverterCore.instance, 0, world, x, y, z);
        }
        return true;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public boolean func_149744_f() {
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            float shrinkAmount = 0.125f;
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)(y + 1) - shrinkAmount), (double)(z + 1));
        }
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntity te;
        if (entity instanceof EntityPlayer && world.func_72805_g(x, y, z) == 2 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCharger) {
            TileEntityCharger charger = (TileEntityCharger)te;
            charger.setPlayer((EntityPlayer)entity);
        }
    }
}

