/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystemManager;

public class ContainerEnergyBridge
extends Container {
    private static final int _flagOffset = 1000;
    private static final Map<Integer, _otherData> _otherDataMap = new HashMap<Integer, _otherData>();
    private TileEntityEnergyBridge _bridge;

    public ContainerEnergyBridge(TileEntityEnergyBridge bridge, InventoryPlayer inv) {
        this._bridge = bridge;
        this.bindPlayerInventory(inv);
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void func_75137_b(int var, int value) {
        if (var < 1000) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(var / _sideData.values().length));
            BridgeSideData sideData = this._bridge.getDataForSide(dir);
            int sideVar = var % _sideData.values().length;
            switch (_sideData.values()[sideVar]) {
                case VOLTAGE_INDEX: {
                    sideData.voltageNameIndex = value;
                    break;
                }
                case IS_CONSUMER: {
                    sideData.isConsumer = value != 0;
                    break;
                }
                case IS_PRODUCER: {
                    sideData.isProducer = value != 0;
                    break;
                }
                case POWER_SYSTEM_ID: {
                    sideData.powerSystem = PowerSystemManager.getInstance().getPowerSystemById(value);
                    break;
                }
                case IS_CONNECTED: {
                    sideData.isConnected = value != 0;
                    break;
                }
                case OUTPUT_RATE_HIGH: {
                    int outputRateLow = (int)sideData.outputRate & 0xFFFF;
                    int outputRateCombined = value << 16 | outputRateLow;
                    sideData.outputRate = outputRateCombined;
                    break;
                }
                case OUTPUT_RATE_LOW: {
                    int outputRateHigh = (int)sideData.outputRate & 0xFFFF0000;
                    int outputRateCombined = outputRateHigh | value & 0xFFFF;
                    sideData.outputRate = outputRateCombined;
                    break;
                }
                case ENERGY_STORED_HIGH: {
                    int energyStoredLow = this._bridge.getEnergyStored() & 0xFFFF;
                    int energyStoredCombined = value << 16 | energyStoredLow;
                    this._bridge.setEnergyStored(energyStoredCombined);
                    break;
                }
                case ENERGY_STORED_LOW: {
                    int energyStoredHigh = this._bridge.getEnergyStored() & 0xFFFF0000;
                    int energyStoredCombined = energyStoredHigh | value & 0xFFFF;
                    this._bridge.setEnergyStored(energyStoredCombined);
                }
            }
        } else {
            switch (_otherDataMap.get(var)) {
                case INPUT_LIMITED: {
                    this._bridge.setIsInputLimited(value != 0);
                    break;
                }
                case ENERGY_SCALED_HIGH: {
                    int energyScaledLow = this._bridge.getEnergyScaled() & 0xFFFF;
                    int energyScaledCombined = value << 16 | energyScaledLow;
                    this._bridge.setEnergyScaled(energyScaledCombined);
                    break;
                }
                case ENERGY_SCALED_LOW: {
                    int energyScaledHigh = this._bridge.getEnergyScaled() & 0xFFFF0000;
                    int energyScaledCombined = energyScaledHigh | value & 0xFFFF;
                    this._bridge.setEnergyScaled(energyScaledCombined);
                }
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int side = 0; side < 6; ++side) {
            ForgeDirection d = ForgeDirection.getOrientation((int)side);
            BridgeSideData data = this._bridge.getDataForSide(d);
            for (Object _crafter : this.field_75149_d) {
                ICrafting crafter = (ICrafting)_crafter;
                int sideVal = side * _sideData.values().length;
                crafter.func_71112_a((Container)this, sideVal + _sideData.VOLTAGE_INDEX.ordinal(), data.voltageNameIndex);
                crafter.func_71112_a((Container)this, sideVal + _sideData.IS_CONSUMER.ordinal(), data.isConsumer ? 1 : 0);
                crafter.func_71112_a((Container)this, sideVal + _sideData.IS_PRODUCER.ordinal(), data.isProducer ? 1 : 0);
                if (data.powerSystem != null) {
                    crafter.func_71112_a((Container)this, sideVal + _sideData.POWER_SYSTEM_ID.ordinal(), PowerSystemManager.getInstance().getPowerSystemId(data.powerSystem.getId()));
                }
                crafter.func_71112_a((Container)this, sideVal + _sideData.IS_CONNECTED.ordinal(), data.isConnected ? 1 : 0);
                crafter.func_71112_a((Container)this, sideVal + _sideData.OUTPUT_RATE_HIGH.ordinal(), (int)((short)((int)data.outputRate >> 16)));
                crafter.func_71112_a((Container)this, sideVal + _sideData.OUTPUT_RATE_LOW.ordinal(), (int)((short)((int)data.outputRate & 0xFFFF)));
                crafter.func_71112_a((Container)this, _sideData.ENERGY_STORED_HIGH.ordinal(), (int)((short)(this._bridge.getEnergyStored() >> 16)));
                crafter.func_71112_a((Container)this, _sideData.ENERGY_STORED_LOW.ordinal(), (int)((short)(this._bridge.getEnergyStored() & 0xFFFF)));
            }
        }
        for (Object _crafter : this.field_75149_d) {
            ICrafting crafter = (ICrafting)_crafter;
            crafter.func_71112_a((Container)this, _otherData.INPUT_LIMITED.getValue(), this._bridge.isInputLimited() ? 1 : 0);
            crafter.func_71112_a((Container)this, _otherData.ENERGY_SCALED_HIGH.getValue(), (int)((short)(this._bridge.getEnergyScaled() >> 16)));
            crafter.func_71112_a((Container)this, _otherData.ENERGY_SCALED_LOW.getValue(), (int)((short)(this._bridge.getEnergyScaled() & 0xFFFF)));
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 113 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 171));
        }
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        return null;
    }

    static {
        for (_otherData data : _otherData.values()) {
            _otherDataMap.put(data.getValue(), data);
        }
    }

    private static enum _otherData {
        INPUT_LIMITED(1000),
        ENERGY_SCALED_HIGH(1001),
        ENERGY_SCALED_LOW(1002);

        int value;

        private _otherData(int newValue) {
            this.value = newValue;
        }

        int getValue() {
            return this.value;
        }
    }

    private static enum _sideData {
        VOLTAGE_INDEX,
        IS_CONSUMER,
        IS_PRODUCER,
        POWER_SYSTEM_ID,
        IS_CONNECTED,
        OUTPUT_RATE_HIGH,
        OUTPUT_RATE_LOW,
        ENERGY_STORED_HIGH,
        ENERGY_STORED_LOW;

    }
}

