/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.power.PowerSystem;

public class PowerSystemManager {
    private static PowerSystemManager instance;
    private Map<String, PowerSystem> powerSystems = new HashMap<String, PowerSystem>();
    private List<String> systemIds = new ArrayList<String>();

    public static PowerSystemManager getInstance() {
        if (instance == null) {
            instance = new PowerSystemManager();
        }
        return instance;
    }

    public void registerPowerSystem(PowerSystem powerSystem) {
        this.registerPowerSystem(powerSystem.getId(), powerSystem);
        this.systemIds.add(powerSystem.getId());
    }

    public void registerPowerSystem(String id, PowerSystem powerSystem) {
        this.powerSystems.put(id, powerSystem);
    }

    public PowerSystem getPowerSystemByName(String name) {
        return this.powerSystems.containsKey(name) ? this.powerSystems.get(name) : null;
    }

    public int getPowerSystemId(String name) {
        return this.systemIds.lastIndexOf(name);
    }

    public PowerSystem getPowerSystemById(int id) {
        String name = this.systemIds.get(id);
        return this.getPowerSystemByName(name);
    }

    public void registerBlocks() {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.registerBlocks();
        }
    }

    public void registerCommonRecipes() {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.registerCommonRecipes();
        }
    }

    public void loadConfigs(Configuration c) {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.loadConfig(c);
        }
    }

    public void saveConfigs(Configuration c) {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.saveConfig(c);
        }
    }
}

