/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.base;

import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.base.TileEntityBridgeComponent;

public abstract class TileEntityEnergyConsumer<T>
extends TileEntityBridgeComponent<T> {
    public TileEntityEnergyConsumer(PowerSystem powerSystem, int voltageNameIndex, Class<T> adjacentClass) {
        super(powerSystem, voltageNameIndex, adjacentClass);
    }

    protected double storeEnergy(double energy, boolean simulate) {
        for (Map.Entry<ForgeDirection, TileEntityEnergyBridge> bridge : this.getBridges().entrySet()) {
            energy = bridge.getValue().storeEnergy(energy, simulate);
            if (!(energy <= 0.0)) continue;
            return 0.0;
        }
        return energy;
    }

    protected int getTotalEnergyDemand() {
        int demand = 0;
        for (Map.Entry<ForgeDirection, TileEntityEnergyBridge> bridge : this.getBridges().entrySet()) {
            demand += bridge.getValue().getEnergyStoredMax() - bridge.getValue().getEnergyStored();
        }
        return demand;
    }

    public abstract double getInputRate();
}

