/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.systems.ic2.BlockIndustrialCraft;
import powercrystals.powerconverters.power.systems.ic2.ChargeHandlerIndustrialCraft;
import powercrystals.powerconverters.power.systems.ic2.ItemBlockIndustrialCraft;
import powercrystals.powerconverters.power.systems.ic2.TileEntityIndustrialCraftConsumer;
import powercrystals.powerconverters.power.systems.ic2.TileEntityIndustrialCraftProducer;

public class PowerIndustrialcraft
extends PowerSystem {
    public static final String id = "IC2";
    public static final float DEFAULT_ENERGY_PER_INPUT = 4000.0f;
    public static final float DEFAULT_ENERGY_PER_OUTPUT = 4000.0f;
    public static final String CATEGORY_FACTORIZATION = "powersystems.ic2";
    public static final String[] VOLTAGE_NAMES = new String[]{"LV", "MV", "HV", "EV", "UV"};
    public static final int[] VOLTAGE_VALUES = new int[]{32, 128, 512, 2048, 8192};

    public PowerIndustrialcraft() {
        this.name = "Industrialcraft";
        this._internalEnergyPerInput = 4000.0f;
        this._internalEnergyPerOutput = 4000.0f;
        this._unit = "EU/t";
        this.voltageNames = VOLTAGE_NAMES;
        this.voltageValues = VOLTAGE_VALUES;
        this.block = new BlockIndustrialCraft();
        this.itemBlock = ItemBlockIndustrialCraft.class;
        this.consumer = TileEntityIndustrialCraftConsumer.class;
        this.producer = TileEntityIndustrialCraftProducer.class;
        TileEntityCharger.registerChargeHandler(new ChargeHandlerIndustrialCraft());
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.block, (Class)this.itemBlock, (String)"converter.ic2");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterIC2Consumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterIC2Producer");
    }

    @Override
    public void registerCommonRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 3), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 2), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 5), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 4), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 5)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 7), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 6)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 6), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 7)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 9), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 8)});
    }

    @Override
    public void loadConfig(Configuration c) {
        this._internalEnergyPerInput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerInput", 4000.0).getDouble(4000.0);
        this._internalEnergyPerOutput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerOutput", 4000.0).getDouble(4000.0);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerInput").set((double)this._internalEnergyPerInput);
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerOutput").set((double)this._internalEnergyPerOutput);
    }
}

