/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.systems.rf.BlockRF;
import powercrystals.powerconverters.power.systems.rf.ChargeHandlerRF;
import powercrystals.powerconverters.power.systems.rf.ItemBlockRF;
import powercrystals.powerconverters.power.systems.rf.TileEntityRFConsumer;
import powercrystals.powerconverters.power.systems.rf.TileEntityRFProducer;

public class PowerRedstoneFlux
extends PowerSystem {
    public static final String id = "RF";
    public static final float DEFAULT_ENERGY_PER_INPUT = 1000.0f;
    public static final float DEFAULT_ENERGY_PER_OUTPUT = 1000.0f;
    public static final String CATEGORY_BUILDCRAFT = "powersystems.rf";

    public PowerRedstoneFlux() {
        this.name = "RedstoneFlux";
        this._internalEnergyPerInput = 1000.0f;
        this._internalEnergyPerOutput = 1000.0f;
        this._unit = "RF/t";
        this.block = new BlockRF();
        this.itemBlock = ItemBlockRF.class;
        this.consumer = TileEntityRFConsumer.class;
        this.producer = TileEntityRFProducer.class;
        TileEntityCharger.registerChargeHandler(new ChargeHandlerRF());
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.block, (Class)this.itemBlock, (String)"converter.rf");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterRFConsumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterRFProducer");
    }

    @Override
    public void registerCommonRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 1)});
    }

    @Override
    public void loadConfig(Configuration c) {
        this._internalEnergyPerInput = (float)c.get(CATEGORY_BUILDCRAFT, "internalEnergyPerInput", 1000.0).getDouble(1000.0);
        this._internalEnergyPerOutput = (float)c.get(CATEGORY_BUILDCRAFT, "internalEnergyPerOutput", 1000.0).getDouble(1000.0);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(CATEGORY_BUILDCRAFT).get("internalEnergyPerInput").set((double)this._internalEnergyPerInput);
        c.getCategory(CATEGORY_BUILDCRAFT).get("internalEnergyPerOutput").set((double)this._internalEnergyPerOutput);
    }
}

