/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.systems.steam.BlockSteam;
import powercrystals.powerconverters.power.systems.steam.ItemBlockSteam;
import powercrystals.powerconverters.power.systems.steam.TileEntitySteamConsumer;
import powercrystals.powerconverters.power.systems.steam.TileEntitySteamProducer;

public class PowerSteam
extends PowerSystem {
    public static String id = "STEAM";
    public static final float DEFAULT_ENERGY_PER_INPUT = 500.0f;
    public static final float DEFAULT_ENERGY_PER_OUTPUT = 500.0f;
    public static final String CATEGORY_STEAM = "powersystems.steam";
    private static final int THROTTLE_CONSUMER_DEFAULT = 1000;
    private static final int THROTTLE_PRODUCER_DEFAULT = 1000;
    private int throttleConsumer = 1000;
    private int throttleProducer = 1000;

    public PowerSteam() {
        this.name = "Steam";
        this._internalEnergyPerInput = 500.0f;
        this._internalEnergyPerOutput = 500.0f;
        this._unit = "mB/t";
        this.block = new BlockSteam();
        this.itemBlock = ItemBlockSteam.class;
        this.consumer = TileEntitySteamConsumer.class;
        this.producer = TileEntitySteamProducer.class;
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.block, (Class)this.itemBlock, (String)"converter.steam");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterSteamConsumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterSteamProducer");
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerCommonRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 1)});
    }

    @Override
    public void loadConfig(Configuration c) {
        this._internalEnergyPerInput = (float)c.get(CATEGORY_STEAM, "internalEnergyPerInput", 500.0).getDouble(500.0);
        this._internalEnergyPerOutput = (float)c.get(CATEGORY_STEAM, "internalEnergyPerOutput", 500.0).getDouble(500.0);
        this.throttleConsumer = c.get(CATEGORY_STEAM, "throttle.steamConsumer", 1000, "mB/t").getInt(1000);
        this.throttleProducer = c.get(CATEGORY_STEAM, "throttle.steamProducer", 1000, "mB/t\n (Suggested value for mod expoit handling = 1; this does not diminish steam return)").getInt(1000);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(CATEGORY_STEAM).get("internalEnergyPerInput").set((double)this._internalEnergyPerInput);
        c.getCategory(CATEGORY_STEAM).get("internalEnergyPerOutput").set((double)this._internalEnergyPerOutput);
        c.getCategory(CATEGORY_STEAM).get("throttle.steamConsumer").set(this.throttleConsumer);
        c.getCategory(CATEGORY_STEAM).get("throttle.steamProducer").set(this.throttleProducer);
    }

    public int getThrottleConsumer() {
        return this.throttleConsumer;
    }

    public int getThrottleProducer() {
        return this.throttleProducer;
    }
}

