/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.buildcraft;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;
import powercrystals.powerconverters.power.systems.PowerBuildcraft;

public class TileEntityBuildCraftConsumer
extends TileEntityEnergyConsumer<IPowerEmitter>
implements IPowerReceptor,
IPipeConnection {
    private PowerHandler _powerProvider = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
    private int _mjLastTick = 0;
    private long _lastTickInjected;
    private Map<ForgeDirection, IPipeTile> _adjacentPipes;
    private Map<ForgeDirection, IPowerEmitter> _adjacentPowerSources;

    public TileEntityBuildCraftConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerBuildcraft.id), 0, IPowerEmitter.class);
        this._powerProvider.configure(0.0, 100.0, 0.0, 1000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72820_D() - this._lastTickInjected > 1L) {
            this._lastTickInjected = this.field_145850_b.func_72820_D();
            this._mjLastTick = 0;
        }
        this.receiveEnergy();
    }

    public void receiveEnergy() {
        double energyToUse;
        double leftOvers;
        double consumed;
        double finalConsumption;
        if (this._lastTickInjected != this.field_145850_b.func_72820_D()) {
            this._lastTickInjected = this.field_145850_b.func_72820_D();
            this._mjLastTick = 0;
        }
        if ((finalConsumption = (consumed = this._powerProvider.useEnergy(0.0, this._powerProvider.getEnergyStored(), false)) - (leftOvers = (double)((float)this.storeEnergy(energyToUse = consumed * (double)this.getPowerSystem().getInternalEnergyPerInput(), false))) * (double)this.getPowerSystem().getInternalEnergyPerInput()) > 0.0) {
            this._powerProvider.useEnergy(0.0, finalConsumption, true);
            this._mjLastTick = (int)finalConsumption;
        }
    }

    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection dir) {
        return this._powerProvider.getPowerReceiver();
    }

    public void doWork(PowerHandler handler) {
    }

    @Override
    public double getInputRate() {
        return this._mjLastTick;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        return pipeType == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.DEFAULT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public void onNeighboorChanged() {
        super.onNeighboorChanged();
        this._adjacentPipes = new HashMap<ForgeDirection, IPipeTile>();
        this._adjacentPowerSources = new HashMap<ForgeDirection, IPowerEmitter>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = BlockPosition.getAdjacentTileEntity(this, direction);
            if (te == null) continue;
            if (IPipeTile.class.isAssignableFrom(te.getClass())) {
                this._adjacentPipes.put(direction, (IPipeTile)te);
                continue;
            }
            if (!IPowerEmitter.class.isAssignableFrom(te.getClass())) continue;
            this._adjacentPowerSources.put(direction, (IPowerEmitter)te);
        }
    }

    @Override
    public boolean isConnected() {
        for (Map.Entry<ForgeDirection, IPipeTile> entry : this._adjacentPipes.entrySet()) {
            if (!entry.getValue().isPipeConnected(entry.getKey().getOpposite())) continue;
            return true;
        }
        for (Map.Entry<ForgeDirection, IPipeTile> entry : this._adjacentPowerSources.entrySet()) {
            if (!((IPowerEmitter)entry.getValue()).canEmitPowerFrom(entry.getKey().getOpposite())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSideConnected(int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        IPipeTile pipe = this._adjacentPipes.get(direction);
        if (pipe != null && pipe.isPipeConnected(direction)) {
            return true;
        }
        IPowerEmitter emitter = this._adjacentPowerSources.get(direction);
        return emitter != null && emitter.canEmitPowerFrom(direction);
    }

    @Override
    public boolean isSideConnectedClient(int side) {
        TileEntity te = BlockPosition.getAdjacentTileEntity(this, ForgeDirection.getOrientation((int)side));
        return te != null && (IPipeTile.class.isAssignableFrom(te.getClass()) || IPowerEmitter.class.isAssignableFrom(te.getClass()));
    }
}

