/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.buildcraft;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.systems.PowerBuildcraft;

public class TileEntityBuildCraftProducer
extends TileEntityEnergyProducer<IPowerReceptor>
implements IPipeConnection,
IPowerEmitter {
    public TileEntityBuildCraftProducer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerBuildcraft.id), 0, IPowerReceptor.class);
    }

    @Override
    public double produceEnergy(double energy) {
        float mj = (float)(energy / (double)this.getPowerSystem().getInternalEnergyPerOutput());
        for (Map.Entry output : this.getTiles().entrySet()) {
            PowerHandler.PowerReceiver pp = ((IPowerReceptor)output.getValue()).getPowerReceiver(output.getKey().getOpposite());
            if (pp == null || !(pp.getMinEnergyReceived() <= (double)mj)) continue;
            float mjUsed = (float)Math.min((double)mj, pp.powerRequest());
            if (!((mj -= (mjUsed = (float)pp.receiveEnergy(PowerHandler.Type.STORAGE, (double)mjUsed, output.getKey().getOpposite()))) <= 0.0f)) continue;
            return 0.0;
        }
        return mj * this.getPowerSystem().getInternalEnergyPerOutput();
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        return pipeType == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.DEFAULT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public boolean canEmitPowerFrom(ForgeDirection direction) {
        return true;
    }
}

