/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.factorization;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;

public class TileEntityFactorizationConsumer
extends TileEntityEnergyConsumer<IChargeConductor>
implements IChargeConductor {
    private Charge _charge = new Charge((IChargeConductor)this);
    private int _chargeLastTick = 0;
    private static final int _maxCG = 1000;
    private boolean neighbourDirty = false;

    public TileEntityFactorizationConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("FZ"), 0, IChargeConductor.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this._charge.getValue() < 1000) {
            this._charge.update();
        }
        if (this._charge.getValue() > 0) {
            int used = this._charge.tryTake(this._charge.getValue());
            this._chargeLastTick = MathHelper.func_76141_d((float)used);
            this.storeEnergy((float)used * this.getPowerSystem().getInternalEnergyPerInput(), false);
        } else {
            this._chargeLastTick = 0;
        }
    }

    @Override
    public double getInputRate() {
        return this._chargeLastTick;
    }

    public Charge getCharge() {
        return this._charge;
    }

    public String getInfo() {
        return null;
    }

    public Coord getCoord() {
        return new Coord((TileEntity)this);
    }

    @Override
    public void onNeighboorChanged() {
        super.onNeighboorChanged();
        try {
            Class<?> fzNullClass = Class.forName("factorization.shared.TileEntityFzNull");
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
                if (te == null || !fzNullClass.isAssignableFrom(te.getClass())) continue;
                this.neighbourDirty = true;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        if (this.neighbourDirty) {
            this.onNeighboorChanged();
            this.neighbourDirty = false;
        }
        return super.isConnected();
    }
}

