/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.ic2;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import powercrystals.powerconverters.common.IChargeHandler;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.systems.PowerIndustrialcraft;

public class ChargeHandlerIndustrialCraft
implements IChargeHandler {
    @Override
    public PowerSystem getPowerSystem() {
        return PowerSystemManager.getInstance().getPowerSystemByName("IC2");
    }

    @Override
    public boolean canHandle(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IElectricItem;
    }

    @Override
    public int charge(ItemStack stack, int energyInput) {
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem electricItem = (IElectricItem)stack.func_77973_b();
            PowerIndustrialcraft ic2 = (PowerIndustrialcraft)this.getPowerSystem();
            double eu = (float)energyInput / ic2.getInternalEnergyPerOutput();
            eu -= ElectricItem.manager.charge(stack, eu, electricItem.getTier(stack), false, false);
            return (int)(eu * (double)ic2.getInternalEnergyPerOutput());
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int energyRequest) {
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem electricItem = (IElectricItem)stack.func_77973_b();
            PowerIndustrialcraft ic2 = (PowerIndustrialcraft)this.getPowerSystem();
            double eu = (float)energyRequest / ic2.getInternalEnergyPerOutput();
            eu = ElectricItem.manager.discharge(stack, eu, electricItem.getTier(stack), false, false, false);
            return (int)(eu * (double)ic2.getInternalEnergyPerInput());
        }
        return 0;
    }
}

