/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;

public class TileEntityIndustrialCraftConsumer
extends TileEntityEnergyConsumer<IEnergyEmitter>
implements IEnergySink {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private double _euLastTick;
    private long _lastTickInjected;

    public TileEntityIndustrialCraftConsumer() {
        this(0);
    }

    public TileEntityIndustrialCraftConsumer(int voltageIndex) {
        super(PowerSystemManager.getInstance().getPowerSystemByName("IC2"), voltageIndex, IEnergyEmitter.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this._didFirstAddToNet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
        if (this.field_145850_b.func_72820_D() - this._lastTickInjected > 2L) {
            this._euLastTick = 0.0;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_145843_s() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return (float)this.getTotalEnergyDemand() / this.getPowerSystem().getInternalEnergyPerInput();
    }

    public int getSinkTier() {
        return this._voltageIndex;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double pcuNotStored = this.storeEnergy(amount * (double)this.getPowerSystem().getInternalEnergyPerInput(), false);
        double euNotStored = pcuNotStored / (double)this.getPowerSystem().getInternalEnergyPerInput();
        double euThisInjection = amount - euNotStored;
        if (this._lastTickInjected == this.field_145850_b.func_72820_D()) {
            this._euLastTick += euThisInjection;
        } else {
            this._euLastTick = euThisInjection;
            this._lastTickInjected = this.field_145850_b.func_72820_D();
        }
        return euNotStored;
    }

    @Override
    public double getInputRate() {
        return this._euLastTick;
    }
}

