/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.util.ICustomHandler;

public class TileEntityIndustrialCraftProducer
extends TileEntityEnergyProducer<IEnergyAcceptor>
implements IEnergySource,
ICustomHandler {
    private double maxSendEnergy;
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private double lastSentEnergy;

    public TileEntityIndustrialCraftProducer() {
        this(0);
    }

    public TileEntityIndustrialCraftProducer(int voltageIndex) {
        super(PowerSystemManager.getInstance().getPowerSystemByName("IC2"), voltageIndex, IEnergyAcceptor.class);
        this.setMaxSendEnergy(voltageIndex);
    }

    private void setMaxSendEnergy(int index) {
        this.maxSendEnergy = index == 0 ? 32.0 : (index == 1 ? 128.0 : (index == 2 ? 512.0 : (index == 3 ? 2048.0 : (index == 4 ? 8192.0 : 0.0))));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this._didFirstAddToNet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setMaxSendEnergy(this._voltageIndex);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_145843_s() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    @Override
    public double produceEnergy(double energy) {
        return energy;
    }

    public double getOfferedEnergy() {
        double eu = 0.0;
        for (TileEntityEnergyBridge bridge : this.getBridges().values()) {
            eu += (double)bridge.getEnergyStored();
        }
        return Math.min(this.maxSendEnergy, eu / (double)this.getPowerSystem().getInternalEnergyPerOutput());
    }

    public void drawEnergy(double amount) {
        double drawn = 0.0;
        for (Map.Entry<ForgeDirection, TileEntityEnergyBridge> bridge : this.getBridges().entrySet()) {
            if ((drawn += bridge.getValue().useEnergy(amount * (double)this.getPowerSystem().getInternalEnergyPerOutput(), false) / (double)this.getPowerSystem().getInternalEnergyPerOutput()) >= amount) break;
        }
        this.lastSentEnergy = drawn;
    }

    public int getSourceTier() {
        return this._voltageIndex;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean shouldHandle() {
        return true;
    }

    @Override
    public double getOutputRate() {
        double temp = this.lastSentEnergy;
        this.lastSentEnergy = 0.0;
        return temp;
    }
}

