/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.rf;

import cofh.api.energy.IEnergyHandler;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;

public class TileEntityRFConsumer
extends TileEntityEnergyConsumer<IEnergyHandler>
implements IEnergyHandler {
    private int lastReceivedRF;

    public TileEntityRFConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("RF"), 0, IEnergyHandler.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public double getInputRate() {
        int last = this.lastReceivedRF;
        this.lastReceivedRF = 0;
        return last;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        float energyToReceive = this.getPowerSystem().getInternalEnergyPerInput() * (float)maxReceive;
        int received = (int)((double)energyToReceive - this.storeEnergy(energyToReceive, simulate));
        if (!simulate) {
            this.lastReceivedRF = (int)((float)received / this.getPowerSystem().getInternalEnergyPerInput());
            return this.lastReceivedRF;
        }
        return (int)((float)received / this.getPowerSystem().getInternalEnergyPerInput());
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStored() / this.getPowerSystem().getInternalEnergyPerInput());
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStoredMax() / this.getPowerSystem().getInternalEnergyPerInput());
    }
}

