/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.steam;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;
import powercrystals.powerconverters.power.systems.PowerSteam;

@Optional.Interface(modid="BuildCraft|Core", iface="buildcraft.api.transport.IPipeConnection")
public class TileEntitySteamConsumer
extends TileEntityEnergyConsumer<IFluidHandler>
implements IFluidHandler,
IPipeConnection {
    private FluidTank _steamTank = new FluidTank(1000);
    private int _mBLastTick;

    public TileEntitySteamConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id), 0, IFluidHandler.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this._steamTank.getFluidAmount() > 0) {
            PowerSteam steam = (PowerSteam)PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id);
            int amount = Math.min(this._steamTank.getFluidAmount(), steam.getThrottleConsumer());
            float energy = (float)amount * steam.getInternalEnergyPerInput();
            energy = (int)this.storeEnergy(energy, false);
            int toDrain = (int)((float)amount - energy / steam.getInternalEnergyPerInput());
            this._steamTank.drain(toDrain, true);
            this._mBLastTick = toDrain;
        } else {
            this._mBLastTick = 0;
        }
    }

    @Override
    public int getVoltageIndex() {
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid().getName().equalsIgnoreCase("steam")) {
            return this._steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this._steamTank.getInfo()};
    }

    @Override
    public double getInputRate() {
        return this._mBLastTick;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        if (pipeType == IPipeTile.PipeType.FLUID) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

