/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.steam;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.systems.PowerSteam;

@Optional.Interface(modid="BuildCraft|Core", iface="buildcraft.api.transport.IPipeConnection")
public class TileEntitySteamProducer
extends TileEntityEnergyProducer<IFluidHandler>
implements IFluidHandler,
IPipeConnection {
    public TileEntitySteamProducer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id), 0, IFluidHandler.class);
    }

    @Override
    public double produceEnergy(double energy) {
        PowerSteam powerSteam = (PowerSteam)PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id);
        energy /= (double)powerSteam.getInternalEnergyPerOutput();
        for (int i = 0; i < 6; ++i) {
            BlockPosition bp = new BlockPosition(this);
            bp.orientation = ForgeDirection.getOrientation((int)i);
            bp.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(bp.x, bp.y, bp.z);
            if (te instanceof IFluidHandler) {
                int steam = (int)Math.min(energy, (double)powerSteam.getThrottleProducer());
                FluidStack stack = FluidRegistry.getFluidStack((String)"steam", (int)steam);
                if (stack == null) {
                    FluidRegistry.getFluidStack((String)"Steam", (int)steam);
                }
                energy -= (double)((IFluidHandler)te).fill(bp.orientation.getOpposite(), stack, true);
            }
            if (!(energy <= 0.0)) continue;
            return 0.0;
        }
        return energy * (double)powerSteam.getInternalEnergyPerOutput();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        if (pipeType == IPipeTile.PipeType.FLUID) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

