/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilter;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.ISpecialSortingInventory;
import com.dynious.refinedrelocation.api.tileentity.grid.SpecialLocalizedStack;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.DrawerFilter;
import com.jaquadro.minecraft.storagedrawers.storage.IUpgradeProvider;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class DrawerSortingInventory {
    private ISpecialSortingInventory parent;
    private IDrawerGroup group;
    private IInventory inventory;
    private IUpgradeProvider upgrade;
    private ISortingInventoryHandler sortingHandler;
    private DrawerFilter filter;
    private boolean isAttached;

    public DrawerSortingInventory(TileEntity tileEntity, IDrawerGroup group, IInventory inventory, IUpgradeProvider upgrade) {
        this.parent = (ISpecialSortingInventory)tileEntity;
        this.group = group;
        this.inventory = inventory;
        this.upgrade = upgrade;
        this.sortingHandler = APIUtils.createSortingInventoryHandler((TileEntity)tileEntity);
        this.filter = new DrawerFilter(group);
    }

    public void attach() {
        if (!this.isAttached) {
            this.getHandler().onTileAdded();
            this.isAttached = true;
        }
    }

    public void detach() {
        if (this.isAttached) {
            this.getHandler().onTileRemoved();
            this.isAttached = false;
        }
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        this.inventory.func_70299_a(slotIndex, itemStack);
        return true;
    }

    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        for (int i = 0; i < this.group.getDrawerCount(); ++i) {
            int added;
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || (drawer = this.group.getDrawer(i)).isEmpty() || !drawer.canItemBeStored(itemStack)) continue;
            int n = added = this.upgrade.isVoid() ? itemStack.field_77994_a : Math.min(drawer.getRemainingCapacity(), itemStack.field_77994_a);
            if (!simulate) {
                drawer.setStoredItemCount(drawer.getStoredItemCount() + added);
            }
            itemStack.field_77994_a -= added;
            if (itemStack.field_77994_a != 0) continue;
            return null;
        }
        return itemStack;
    }

    public SpecialLocalizedStack getLocalizedStackInSlot(int slot) {
        ItemStack itemStack = this.inventory.func_70301_a(slot);
        if (itemStack != null) {
            int drawerSlot = this.group.getDrawerInventory().getDrawerSlot(slot);
            if (!this.group.isDrawerEnabled(drawerSlot)) {
                return null;
            }
            IDrawer drawer = this.group.getDrawer(drawerSlot);
            return new SpecialLocalizedStack(itemStack, this.parent, slot, drawer.getStoredItemCount());
        }
        return null;
    }

    public void alterStackSize(int slot, int alteration) {
        int drawerSlot = this.group.getDrawerInventory().getDrawerSlot(slot);
        if (!this.group.isDrawerEnabled(drawerSlot)) {
            return;
        }
        IDrawer drawer = this.group.getDrawer(drawerSlot);
        drawer.setStoredItemCount(drawer.getStoredItemCount() + alteration);
    }

    public ISortingInventory.Priority getPriority() {
        return ISortingInventory.Priority.NORMAL_HIGH;
    }

    public void setPriority(ISortingInventory.Priority priority) {
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public ISortingInventoryHandler getHandler() {
        return this.sortingHandler;
    }

    public void markDirty() {
        this.getHandler().onInventoryChange();
    }
}

