/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lemoncraft.thaumcraft.IAdvancedVisCharger;
import lemoncraft.thaumcraft.WavefrontWrapper;
import lemoncraft.thaumcraft.util.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.tiles.TileMagicWorkbenchCharger;

@SideOnly(value=Side.CLIENT)
public class TileMagicWorkbenchChargerRenderer
extends TileEntitySpecialRenderer {
    private final IModelCustom model = new WavefrontWrapper((WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)RELAY));
    private static final ResourceLocation RELAY = new ResourceLocation("thaumcraft", "textures/models/vis_relay.obj");

    public void renderTileEntityAt(TileMagicWorkbenchCharger tile, double par2, double par4, double par6, float par8) {
        int ticks = Minecraft.func_71410_x().field_71451_h.field_70173_aa;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(par2 + 0.5), (double)(par4 + 0.5), (double)(par6 + 0.5));
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        if (tile instanceof IAdvancedVisCharger) {
            this.field_147501_a.field_147553_e.func_110577_a(((IAdvancedVisCharger)((Object)tile)).getTextureLocation());
        } else {
            UtilsFX.bindTexture("textures/models/vis_relay.png");
        }
        this.model.renderPart("RingFloat");
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.5);
        for (int a = 0; a < 4; ++a) {
            this.model.renderPart("Support");
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (tile.color >= 0) {
            int color = TileMagicWorkbenchCharger.colors[tile.color];
            float r = (float)ColorHelper.red(color) / 200.0f;
            float g = (float)ColorHelper.green(color) / 200.0f;
            float b = (float)ColorHelper.blue(color) / 200.0f;
            GL11.glColor3f((float)r, (float)g, (float)b);
        }
        float scale = MathHelper.func_76126_a((float)(((float)ticks + par8) / 2.0f)) * 0.05f + 0.95f;
        int j = (VisNetHandler.isNodeValid(tile.getParent()) ? 50 : 0) + (int)(150.0f * scale);
        int k = j % 65536;
        int l = j / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)k, (float)l);
        this.model.renderPart("Crystal");
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderTileEntityAt((TileMagicWorkbenchCharger)par1TileEntity, par2, par4, par6, par8);
    }
}

